package commons.aop;

import java.util.List;

import commons.aop.spi.Aspect;

/**
 * AopEngine is as engine for weaving aspect.
 * 
 * @author shot
 */
public interface AopEngine {

	void startup();

	<T> Class<? extends T> getEnhancedClass(Class<? extends T> originalClass,
			List<Aspect> aspects);

	<T> T createEnhancedClassInstance(Class<? extends T> originalClass,
			List<Aspect> aspects);

	void shutdown();

}
