package commons.annotation.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * &#064;Component is the base annotation to notify that is a component for IoC
 * container like Lucy.A component must be annotated with &#064;Component.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Component {

	/**
	 * strict() is a notifier that Lucy gets strict mode which means, do not
	 * inject at all until assume property is set.
	 * 
	 * TODO impl this.
	 */
	boolean strict() default false;

	/**
	 * assume() is an optional feature for injection. If strict() sets true, you
	 * must specify the class you would like to inject, like
	 * \@Component(strict=true, assume=HogeServiceImpl.class)
	 * 
	 * TODO impl this.
	 */
	Class<?> assume() default Object.class;

}
