package commons.annotation.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import commons.aop.spi.Interceptor;

/**
 * &#064;Aspect is an annotation of aspect.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target( { ElementType.TYPE, ElementType.METHOD })
public @interface Aspect {

	String INTERCEPT_BY = "interceptBy";

	String POINTCUT = "pointcut";

	Class<? extends Interceptor>[] interceptBy();

	String[] pointcut() default ".*";

}
