package commons.annotation.composite;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import commons.annotation.Composite;
import commons.annotation.core.Component;
import commons.annotation.core.Request;

/**
 * RequestScope is a composite annotation representing http request scope.It
 * includes meanings of &#064;Component, &#064;Request.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Composite
@Component
@Request
public @interface RequestScope {

}
