package commons.annotation.composite;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import commons.annotation.Composite;
import commons.annotation.core.Component;
import commons.annotation.core.Prototype;

/**
 * &#064;PrototypeScope is composite annotation that means this annotation has
 * two meanings, &#064;Component and &#064;Prototype.
 * 
 * @author shot
 * @see commons.annotation.core.Component
 * @see commons.annotation.core.Prototype
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Composite
@Component
@Prototype
public @interface PrototypeScope {

}
