package commons.annotation.composite;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import commons.annotation.Composite;
import commons.annotation.core.Application;
import commons.annotation.core.Component;

/**
 * ApplicationScope is a composite annotation representing server context
 * scope.It includes meanings of &#064;Component, &#064;Application.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Composite
@Component
@Application
public @interface ApplicationScope {

}
