package commons.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Published annotation should be used when an interface/class/method/field is
 * exposed and fixed as public API.So, an interface/class/method/field annotated
 * by &#064;Published must sustain backward compatibility.If it needs additional
 * change, which means existing method/field has no change, minor version should
 * be up. If changes are much more drastic, major version up should be
 * considered.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.SOURCE)
public @interface Published {
}
