package commons.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * &#064;LookUp is used when composite annotation value to looking up.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value = ElementType.METHOD)
public @interface Lookup {

	Class<? extends Annotation> value();

	String alias() default "";

}
