package commons.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * &#064;Composite is an annotation to notify the annotated annotation is
 * composed with multiple roles.
 * 
 * @author shot
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value = ElementType.ANNOTATION_TYPE)
public @interface Composite {

	public enum EvaluateType {
		INCLUDE_THIS, PARENT_ONLY;
	}

	EvaluateType value() default EvaluateType.INCLUDE_THIS;
}
