package commons;

import java.util.LinkedList;

import commons.util.Assertion;

/**
 * Disposer helps dispose resources correctly. The dispose() must be called when
 * all resources that may cause memory leak should be released.
 * 
 * @author shot
 */
public class Disposer {

	protected static final LinkedList<Disposable> disposables = new LinkedList<Disposable>();

	public static void add(final Disposable disposable) {
		disposables.add(Assertion.notNull(disposable));
	}

	public static synchronized void dispose() {
		try {
			while (!disposables.isEmpty()) {
				Disposable disposable = disposables.removeLast();
				try {
					disposable.dispose();
				} catch (final Throwable t) {
					t.printStackTrace();
				} finally {
					disposable = null;
				}
			}
		} finally {
			disposables.clear();
		}
	}

}
