package commons;

import java.util.Collections;
import java.util.Set;

/**
 * Constants.
 * 
 * @author shot
 */
public interface Constants {

	Object[] EMPTY_ARRAY = new Object[0];

	String[] EMPTY_STRING_ARRAY = new String[0];

	Class<?>[] EMPTY_CLASS_ARRAY = new Class<?>[0];

	int[] EMPTY_PRIMITIVE_INT_ARRAY = new int[0];

	Integer[] EMPTY_INT_ARRAY = new Integer[0];

	double[] EMPTY_PRIMITIVE_DOUBLE_ARRAY = new double[0];

	Double[] EMPTY_DOUBLE_ARRAY = new Double[0];

	Set<String> EMPTY_STRING_SET = Collections.emptySet();

	Integer INT_DEFAULT_VALUE = new Integer(0);

	Double DOUBLE_DEFAULT_VALUE = new Double(0);

	Long LONG_DEFAULT_VALUE = new Long(0);

	Float FLOAT_DEFAULT_VALUE = new Float(0);

	Short SHORT_DEFAULT_VALUE = new Short((short) 0);

	Boolean BOOLEAN_DEFAULT_VALUE = Boolean.FALSE;

	Byte BYTE_DEFAULT_VALUE = Byte.valueOf((byte) 0);

	Character CHAR_DEFAULT_VALUE = Character.valueOf((char) 0);

	String TEXT_CONTENT_TYPE = "text/plain";

	String HTML_CONTENT_TYPE = "text/html";

	String ANY_CONTENT_TYPE = "*/*";

	String XHTML_CONTENT_TYPE = "application/xhtml+xml";

	String APPLICATION_XML_CONTENT_TYPE = "application/xml";

	String TEXT_XML_CONTENT_TYPE = "text/xml";

	String PREFIX_CHARSET = "charset=";

	String MULTIPART = "multipart/";

	String MULTIPART_FORM_DATA = "multipart/form-data";

	String MULTIPART_MIXED = "multipart/mixed";

	String CONTENT_TYPE = "Content-type";

	String CONTENT_DISPOSITION = "Content-disposition";

	String CONTENT_LENGTH = "Content-length";

	String FORM_DATA = "form-data";

	String ATTACHMENT = "attachment";

	String CLASS_SUFFIX = ".class";

	String WEB_INF_CLASSES_PATH = "WEB-INF/classes/";

	String WAR_SUFFIX = ".war";

}
