/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.inject;

import org.t2framework.commons.exception.IllegalPropertyRuntimeException;
import org.t2framework.commons.meta.ExpressionAware;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Logger;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.exception.CyclicReferenceRuntimeException;
import org.t2framework.lucy.inject.AbstractInjector;
import org.t2framework.lucy.inject.InjectorUtil;

public class PropertyInjector
extends AbstractInjector<PropertyDesc<?>> {
    protected static Logger logger = Logger.getLogger(PropertyInjector.class);
    protected final String targetClassName;
    protected final String targetWriteMethodName;

    public PropertyInjector(PropertyDesc<?> propertyDesc) {
        super(propertyDesc);
        this.targetClassName = propertyDesc.getTargetClass().getName();
        if (!propertyDesc.isWritable()) {
            throw new IllegalStateException();
        }
        this.targetWriteMethodName = propertyDesc.getWriteMethod().getName();
    }

    @Override
    public <T> T inject(T t, Lucy lucy) throws CyclicReferenceRuntimeException, IllegalPropertyRuntimeException {
        PropertyDesc propertyDesc = (PropertyDesc)this.getConfigContainer();
        AbstractInjector.InjectInfo info = this.getInjectInfo();
        Class type = propertyDesc.getPropertyType();
        Object o = this.prepareArg(type, propertyDesc, lucy, info);
        this.injectPropertyDesc(propertyDesc, t, o);
        return t;
    }

    protected <T> void injectPropertyDesc(PropertyDesc propertyDesc, T t, Object arg) {
        if (arg != null) {
            propertyDesc.setValue(t, arg);
        } else {
            Class type = propertyDesc.getPropertyType();
            this.logForNullInject(type, type.isArray());
        }
    }

    protected Object prepareArg(Class<?> type, PropertyDesc<?> propertyDesc, Lucy lucy, AbstractInjector.InjectInfo info) {
        Object o = null;
        o = !type.isArray() ? this.prepareComponent(propertyDesc, type, lucy, info) : this.prepareComponents(propertyDesc, type, lucy, info);
        return o;
    }

    protected void logForNullInject(Class<?> type, boolean isArray) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.getName());
        builder.append(isArray ? "[]" : "");
        logger.log("DLucyCore0002", new Object[]{this.targetClassName, this.targetWriteMethodName, new String(builder)});
    }

    protected Object prepareComponent(PropertyDesc<?> propertyDesc, Class<?> type, Lucy lucy, AbstractInjector.InjectInfo info) {
        Object[] evalResult;
        Object o = null;
        o = propertyDesc.hasExpression() ? ((evalResult = this.evaluateExpression((ExpressionAware)propertyDesc, lucy)) != null && 0 < evalResult.length ? evalResult[0] : null) : (Object)(info.hasNames() ? lucy.get(info.getNames()[0]) : lucy.get(type));
        return o;
    }

    protected Object prepareComponents(PropertyDesc<?> propertyDesc, Class<?> type, Lucy lucy, AbstractInjector.InjectInfo info) {
        Object[] evalResult;
        if (!type.isArray()) {
            return null;
        }
        Object o = null;
        Class[] injectTypes = InjectorUtil.getTypes(propertyDesc);
        Class<?> componentType = type.getComponentType();
        o = injectTypes != null ? super.prepareArgsByTypes(injectTypes, lucy, info) : (propertyDesc.hasExpression() ? ((evalResult = this.evaluateExpression((ExpressionAware)propertyDesc, lucy)) != null && 0 < evalResult.length ? this.convertTypes(evalResult[0], componentType) : null) : lucy.getAll(componentType));
        return o;
    }
}

