/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import java.util.List;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.config.meta.impl.LifeCycleMethodConfig;
import org.t2framework.lucy.config.stax.AbstractExpressionHandler;
import org.t2framework.lucy.config.stax.Attributes;
import org.t2framework.lucy.config.stax.XmlEventContext;
import org.t2framework.lucy.config.stax.XmlEventHandler;
import org.t2framework.lucy.exception.ArgumentMismatchException;
import org.t2framework.lucy.exception.IllegalELResultException;
import org.t2framework.lucy.exception.MethodNotFoundException;

public abstract class LifeCycleTagHandler
extends AbstractExpressionHandler
implements XmlEventHandler {
    protected abstract LifeCycleMethodConfig createConfig(ConfigContainer var1);

    @Override
    public void start(XmlEventContext context, Attributes attributes) {
        String name = attributes.getValue("method");
        if (!StringUtil.isEmpty((String)name)) {
            context.push(name);
        }
    }

    @Override
    public void end(XmlEventContext context, String body) {
        String name = (String)context.pop();
        BeanDesc beanDesc = (BeanDesc)context.peek();
        String s = body.trim();
        if (StringUtil.isEmpty((String)s)) {
            this.setupNoArgMethodDesc(context, beanDesc, name);
        } else {
            List list = beanDesc.getMethodDescs(name);
            Object o = this.evaluateExpression(context, s);
            if (o == null) {
                throw new IllegalELResultException(s, o);
            }
            if (o.getClass().isArray()) {
                Object[] args = (Object[])o;
                this.setupMethodDesc(beanDesc, args, list);
            } else if (o instanceof List) {
                Object[] args = ((List)o).toArray();
                this.setupMethodDesc(beanDesc, args, list);
            } else {
                this.setupSingleArgMethodDesc(beanDesc, o, list);
            }
        }
    }

    protected void setupSingleArgMethodDesc(BeanDesc<?> beanDesc, Object o, List<MethodDesc> list) {
        List<MethodDesc> candidates = this.filterByParameterSize(1, list);
        for (MethodDesc md : candidates) {
            Class type;
            Class[] types = md.getParameterTypes();
            if (types.length != 1 || !(type = Reflections.ClassUtil.toWrapperClass((Class)types[0])).isAssignableFrom(o.getClass())) continue;
            LifeCycleMethodConfig cd = this.createConfig((ConfigContainer)md);
            cd.setArgs(new Object[]{o});
            beanDesc.addConfig((Config)cd);
        }
    }

    protected void setupMethodDesc(BeanDesc<?> beanDesc, Object[] args, List<MethodDesc> list) {
        int length = args.length;
        List<MethodDesc> candidates = this.filterByParameterSize(length, list);
        if (candidates.size() == 1) {
            MethodDesc md = candidates.get(0);
            LifeCycleMethodConfig cd = this.createConfig((ConfigContainer)md);
            cd.setArgs(args);
            beanDesc.addConfig((Config)cd);
            return;
        }
        block0: for (MethodDesc md : candidates) {
            Class[] types = md.getParameterTypes();
            for (int i = 0; i < length; ++i) {
                Object o = args[i];
                Class type = Reflections.ClassUtil.toWrapperClass((Class)types[i]);
                if (!type.isAssignableFrom(o.getClass())) continue block0;
            }
            LifeCycleMethodConfig cd = this.createConfig((ConfigContainer)md);
            cd.setArgs(args);
            beanDesc.addConfig((Config)cd);
        }
    }

    protected List<MethodDesc> filterByParameterSize(int length, List<MethodDesc> list) {
        List candidates = CollectionsUtil.newArrayList();
        for (MethodDesc md : list) {
            if (md.getParameterTypes().length != length) continue;
            candidates.add(md);
        }
        return candidates;
    }

    protected void setupNoArgMethodDesc(XmlEventContext context, BeanDesc<?> beanDesc, String name) {
        MethodDesc md = this.find(context, beanDesc, name);
        LifeCycleMethodConfig config = this.createConfig((ConfigContainer)md);
        beanDesc.addConfig((Config)config);
    }

    protected MethodDesc find(XmlEventContext context, BeanDesc<?> bd, String name) {
        List list = bd.getMethodDescs(name);
        if (list == null || list.size() < 1) {
            throw new MethodNotFoundException(bd.getComponentClass(), name, context.getLineNumber(), context.getColumnNumber());
        }
        for (MethodDesc md : list) {
            Class<?>[] ary = md.getMethod().getParameterTypes();
            if (ary != null && ary.length != 0) continue;
            return md;
        }
        throw new ArgumentMismatchException(bd.getComponentClass(), name, context.getLineNumber(), context.getColumnNumber());
    }
}

