/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.annotation.ConfigurationTarget;
import org.t2framework.commons.exception.NoConfigurationTargetAnnotationException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.DescType;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.meta.impl.ConstructorDescImpl;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.lucy.ConfigBindResult;
import org.t2framework.lucy.ConfigBinder;
import org.t2framework.lucy.behavior.ComponentBehavior;
import org.t2framework.lucy.behavior.DestroyMethodBehavior;
import org.t2framework.lucy.behavior.InitMethodBehavior;
import org.t2framework.lucy.behavior.InjectBehavior;
import org.t2framework.lucy.behavior.PrototypeBehavior;
import org.t2framework.lucy.behavior.SingletonBehavior;
import org.t2framework.lucy.config.meta.InstanceConfig;
import org.t2framework.lucy.config.meta.InstanceConfigFactory;
import org.t2framework.lucy.exception.LucyStartupFailException;
import org.t2framework.lucy.module.LucyAopModule;
import org.t2framework.lucy.spi.Behavior;
import org.t2framework.lucy.spi.LucyConfiguration;

public class ConfigBinderFactory {
    private static ConfigBinder binder;

    public static synchronized void setConfigBinder(ConfigBinder binder) {
        ConfigBinderFactory.binder = (ConfigBinder)Assertion.notNull((Object)binder);
    }

    public static ConfigBinder getConfigBinder() {
        if (binder == null) {
            throw new LucyStartupFailException();
        }
        return binder;
    }

    public static ConfigBinder getConfigBinder(LucyConfiguration conf) {
        Assertion.notNull((Object)conf);
        return ConfigBinderFactory.getConfigBinder().loadConfiguration(conf);
    }

    public static void addBehavior(Class<? extends Behavior> b) {
        Assertion.notNull(b);
        ConfigBinderFactory.getConfigBinder().addBehavior(b);
    }

    public static class DefaultConfigBinderImpl
    implements ConfigBinder {
        protected Map<Class<?>, Class<? extends Behavior>> customBehaviorMap = CollectionsUtil.newHashMap();
        protected Map<Class<?>, Class<? extends Behavior>> defaultBehaviorMap = CollectionsUtil.newHashMap();
        protected Map<Class<? extends Behavior>, ConstructorDesc<Behavior>> behaviorConstructorCache = CollectionsUtil.newHashMap();
        protected LucyConfiguration conf;

        public DefaultConfigBinderImpl() {
            this.init();
        }

        protected void init() {
            this.addDefaultBehavior(ComponentBehavior.class);
            this.addDefaultBehavior(InjectBehavior.class);
            this.addDefaultBehavior(SingletonBehavior.class);
            this.addDefaultBehavior(PrototypeBehavior.class);
            this.addDefaultBehavior(InitMethodBehavior.class);
            this.addDefaultBehavior(DestroyMethodBehavior.class);
        }

        protected void addDefaultBehavior(Class<? extends Behavior> behaviorClass) {
            this.addBehavior(behaviorClass, this.defaultBehaviorMap);
        }

        protected void addBehavior(final Class<? extends Behavior> behaviorClass, final Map<Class<?>, Class<? extends Behavior>> map) {
            DefaultConfigBinderImpl.handleConfigurationTarget(behaviorClass, new ConfigurationTargetHandler<Object>(){

                @Override
                public Object handle(Class<?> targetClass, Class<? extends Behavior> behaviClass) {
                    map.put(targetClass, behaviorClass);
                    return null;
                }
            });
        }

        private static <R> R handleConfigurationTarget(Class<? extends Behavior> behaviorClass, ConfigurationTargetHandler<R> handler) {
            ConfigurationTarget a = behaviorClass.getAnnotation(ConfigurationTarget.class);
            if (a == null) {
                throw new NoConfigurationTargetAnnotationException(behaviorClass);
            }
            for (Class targetClass : a.value()) {
                R r = handler.handle(targetClass, behaviorClass);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public void addBehavior(Class<? extends Behavior> behavior) {
            Assertion.notNull(behavior);
            this.addBehavior(behavior, this.customBehaviorMap);
        }

        @Override
        public synchronized <T> ConfigBindResult bind(final BeanDesc<T> beanDesc) {
            Assertion.notNull(beanDesc);
            ConfigBindResult result = new ConfigBindResult(beanDesc);
            this.bind(new Binder<ClassDesc<T>>(){

                @Override
                public void bind(ClassDesc<T> container, ConfigBindResult result) {
                    for (Config config : container) {
                        Behavior b;
                        ClassDesc configContainer = config.getConfigContainer();
                        if (configContainer == null) {
                            configContainer = container;
                        }
                        if ((b = DefaultConfigBinderImpl.this.createBehavior(beanDesc, config, (ConfigContainer)configContainer)) == null) continue;
                        result.addBehavior((DescType)container, b);
                    }
                }
            }, beanDesc.getClassDesc(), result);
            this.bind(new Binder<List<MethodDesc>>(){

                @Override
                public void bind(List<MethodDesc> list, ConfigBindResult result) {
                    for (MethodDesc md : list) {
                        for (Config config : md) {
                            Behavior b = DefaultConfigBinderImpl.this.createBehavior(beanDesc, config, (ConfigContainer)md);
                            if (b == null) continue;
                            result.addBehavior((DescType)md, b);
                        }
                    }
                }
            }, beanDesc.getAllMethodDesc(), result);
            this.bind(new Binder<List<PropertyDesc<T>>>(){

                @Override
                public void bind(List<PropertyDesc<T>> list, ConfigBindResult result) {
                    for (PropertyDesc pd : list) {
                        for (Config config : pd) {
                            Behavior b = DefaultConfigBinderImpl.this.createBehavior(beanDesc, config, (ConfigContainer)pd);
                            if (b == null) continue;
                            result.addBehavior((DescType)pd, b);
                        }
                    }
                }
            }, beanDesc.getAllPropertyDesc(), result);
            return result;
        }

        private <T> void bind(Binder<T> binder, T container, ConfigBindResult result) {
            binder.bind(container, result);
        }

        protected <T> Behavior createBehavior(BeanDesc<T> beanDesc, Config config, ConfigContainer container) {
            Class type = config.getType();
            return this.createBehavior(beanDesc, type, config, container);
        }

        protected <T> Behavior createBehavior(BeanDesc<T> beanDesc, Class<?> type, Config config, ConfigContainer container) {
            Class<? extends Behavior> clazz = this.findBehaviorClass(type);
            if (clazz != null) {
                ConstructorDescImpl cd = this.behaviorConstructorCache.get(clazz);
                if (cd == null) {
                    cd = new ConstructorDescImpl(clazz);
                    this.behaviorConstructorCache.put(clazz, (ConstructorDesc<Behavior>)cd);
                }
                Constructor c = cd.getSuitableConstructor(new Object[]{beanDesc, container, config});
                Object[] args = new Object[]{beanDesc, container, config};
                return (Behavior)Reflections.ConstructorUtil.newInstance((Constructor)c, (Object[])args);
            }
            return null;
        }

        protected Class<? extends Behavior> findBehaviorClass(final Class<?> type) {
            Class<? extends Behavior> clazz = this.customBehaviorMap.get(type);
            if (clazz != null) {
                return clazz;
            }
            LucyAopModule aopModule = (LucyAopModule)Modules.getModule(LucyAopModule.class);
            if (aopModule != null) {
                Class<? extends Behavior> aspectBehaviorClass = aopModule.getAspectBehaviorClass();
                clazz = DefaultConfigBinderImpl.handleConfigurationTarget(aspectBehaviorClass, new ConfigurationTargetHandler<Class<? extends Behavior>>(){

                    @Override
                    public Class<? extends Behavior> handle(Class<?> targetClass, Class<? extends Behavior> behaviorClass) {
                        if (targetClass == type) {
                            return behaviorClass;
                        }
                        return null;
                    }
                });
            }
            if (clazz != null) {
                return clazz;
            }
            return this.defaultBehaviorMap.get(type);
        }

        @Override
        public ConfigBinder loadConfiguration(LucyConfiguration conf) {
            this.conf = (LucyConfiguration)Assertion.notNull((Object)conf);
            return this;
        }

        @Override
        public void addInstanceConfig(InstanceConfig instanceConfig) {
            InstanceConfigFactory.addInstanceConfig((InstanceConfig)Assertion.notNull((Object)instanceConfig));
        }

        private static interface ConfigurationTargetHandler<R> {
            public R handle(Class<?> var1, Class<? extends Behavior> var2);
        }

        private static interface Binder<T> {
            public void bind(T var1, ConfigBindResult var2);
        }
    }
}

