/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.development.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.t2framework.commons.util.CloseableUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.ServletUtil;

public class SessionLimitationFilter
implements Filter {
    public static final String SESSION_LIMIT_KEY = "limit";
    public static final int DEFAULT_LIMIT = 0xA00000;
    private static Logger log = Logger.getLogger((String)"org.t2framework.t2.development.session");
    protected int limit = 0xA00000;

    public void init(FilterConfig config) throws ServletException {
        this.limit = ServletUtil.getSizeParameter((FilterConfig)config, (String)SESSION_LIMIT_KEY, (int)0xA00000);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(req, res);
        this.validateSessionSize(req);
    }

    protected void validateSessionSize(ServletRequest req) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        int totalSize = 0;
        int counts = 0;
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = session.getAttribute(name);
            totalSize += this.calculateSerializedSize(name, value);
            ++counts;
        }
        log.debug("session object total size:{}, counts:{}(limit:{})", new Object[]{totalSize, counts, this.limit});
        if (this.limit < totalSize) {
            try {
                throw new SessionLimitExceedException(this.limit, totalSize);
            }
            catch (Throwable throwable) {
                session.invalidate();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int calculateSerializedSize(String key, Object value) {
        int n;
        ObjectOutputStream os = null;
        ObjectInputStream is = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(value);
            os.writeObject(key);
            os.flush();
            byte[] data = baos.toByteArray();
            is = new ObjectInputStream(new ByteArrayInputStream(data));
            value = is.readObject();
            n = data.length;
        }
        catch (Throwable e) {
            int n2;
            try {
                String valueClass = value != null ? value.getClass().getName() : "";
                log.error("Serialize Error! name={}, class={}", new Object[]{key, valueClass});
                n2 = 0;
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                CloseableUtil.close(is);
                throw throwable;
            }
            CloseableUtil.close((Closeable)os);
            CloseableUtil.close(is);
            return n2;
        }
        CloseableUtil.close((Closeable)os);
        CloseableUtil.close((Closeable)is);
        return n;
    }

    public void destroy() {
        this.limit = 0xA00000;
    }

    public static class SessionLimitExceedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SessionLimitExceedException(long limit, long totalSize) {
            super("Session limit exceeded(limit:" + limit + ", actual size:" + totalSize + ").");
        }
    }
}

