/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.t2framework.commons.exception.ReflectionRuntimeException;
import org.t2framework.commons.util.Assertion;

public class ReflectionExecutor {
    protected ReflectionExecutor() {
    }

    public static <T> T doSafeAction(final ReflectionAction<T> action) {
        Assertion.notNull(action);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return action.run();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (InvocationTargetException.class.isInstance(cause)) {
                InvocationTargetException e1 = (InvocationTargetException)cause;
                throw new ReflectionRuntimeException(e1.getTargetException());
            }
            throw new ReflectionRuntimeException(cause);
        }
    }

    public static interface ReflectionAction<T> {
        public T run() throws Exception;
    }
}

