/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.Enumeration;
import java.util.Map;
import org.t2framework.commons.util.CollectionsUtil;

public class Foreach {
    public static <T, E extends Throwable> void each(T[] array, ArrayItem<T, E> item) throws E {
        if (array == null || array.length == 0 || item == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            item.each(array[i], i, array);
        }
    }

    public static <T, E extends Throwable> void each(Iterable<T> itr, IterableItem<T, E> item) throws E {
        if (itr == null || item == null) {
            return;
        }
        int i = 0;
        for (T t : itr) {
            item.each(t, i++, itr);
        }
    }

    public static <K, V, E extends Throwable> void each(Map<K, V> map, MapItem<K, V, E> item) throws E {
        if (map == null || map.isEmpty()) {
            return;
        }
        Foreach.each(map.entrySet(), item);
    }

    public static <T, E extends Throwable> void each(Enumeration<T> e, IterableItem<T, E> item) throws E {
        if (e == null || item == null) {
            return;
        }
        CollectionsUtil.EnumerationIterable<T> iterable = CollectionsUtil.newEnumerationIterable(e);
        Foreach.each(iterable, item);
    }

    public static interface EasyMapItem<K, V>
    extends MapItem<K, V, RuntimeException> {
    }

    public static interface MapItem<K, V, E extends Throwable>
    extends IterableItem<Map.Entry<K, V>, E> {
    }

    public static interface EasyIterableItem<T>
    extends IterableItem<T, RuntimeException> {
    }

    public static interface IterableItem<T, E extends Throwable>
    extends Item<T, Iterable<T>, E> {
    }

    public static interface EasyArrayItem<T>
    extends ArrayItem<T, RuntimeException> {
    }

    public static interface ArrayItem<T, E extends Throwable>
    extends Item<T, T[], E> {
    }

    static interface Item<T, ALL, E extends Throwable> {
        public void each(T var1, int var2, ALL var3) throws E;
    }
}

