/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.StreamUtil;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class);

    protected FileUtil() {
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Deprecated
    public static URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] getBytes(File file) {
        return StreamUtil.getBytes(StreamUtil.createFileInputStream(file));
    }

    public static void createNewFile(File file) {
        Assertion.notNull(file);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void delete(File file) {
        Assertion.notNull(file);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.delete(f);
            }
            file.delete();
        }
    }

    public static void copy(File src, File dest) {
        FileUtil.copy(src, dest, false);
    }

    public static void copy(File src, File dest, boolean createNew) {
        Assertion.notNulls(src, dest);
        if (!src.exists() || !src.canRead()) {
            logger.debug("src file :{} does not exists or is not readable.", src.getPath());
            return;
        }
        if (dest.exists() && !dest.canWrite()) {
            logger.debug("dest file :{} is not writable.", dest.getPath());
            return;
        }
        if (!dest.exists()) {
            if (createNew) {
                FileUtil.createNewFile(dest);
            } else {
                logger.debug("dest file :{} does not exist.", dest.getPath());
                return;
            }
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int length;
            in = StreamUtil.createBufferedFileInputStream(src);
            out = StreamUtil.createBufferedFileOutputStream(dest);
            byte[] buf = new byte[1024];
            while (-1 < (length = in.read(buf))) {
                out.write(buf, 0, length);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            StreamUtil.close(in);
            StreamUtil.close(out);
        }
    }
}

