/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    protected static final int INITIAL_CAPACITY = 17;
    protected static final float LOAD_FACTOR = 0.75f;
    protected transient int threshold;
    protected transient Entry<K, V>[] mapTable;
    protected transient Entry<K, V>[] listTable;
    protected transient int size = 0;
    protected transient Set<?> entrySet = null;

    public static <K, V> ArrayMap<K, V> newArrayMap() {
        return new ArrayMap<K, V>();
    }

    public ArrayMap() {
        this(17);
    }

    public ArrayMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this.mapTable = new Entry[initialCapacity];
        this.listTable = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public ArrayMap(Map<K, V> map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.indexOf(value) >= 0;
    }

    public final int indexOf(Object value) {
        if (value != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!value.equals(this.listTable[i].value_)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.listTable[i].value_ != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V>[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry<K, V> e = tbl[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return true;
                }
                e = e.next_;
            }
        } else {
            Entry<K, V> e = tbl[0];
            while (e != null) {
                if (e.key_ == null) {
                    return true;
                }
                e = e.next_;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry<K, V> e = tbl[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return e.value_;
                }
                e = e.next_;
            }
        } else {
            Entry<K, V> e = tbl[0];
            while (e != null) {
                if (e.key_ == null) {
                    return e.value_;
                }
                e = e.next_;
            }
        }
        return null;
    }

    public final V get(int index) {
        return this.getEntry((int)index).value_;
    }

    public final K getKey(int index) {
        return this.getEntry((int)index).key_;
    }

    public final Entry<K, V> getEntry(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:" + this.size);
        }
        return this.listTable[index];
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> e;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            e = this.mapTable[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return this.swapValue(e, value);
                }
                e = e.next_;
            }
        } else {
            e = this.mapTable[0];
            while (e != null) {
                if (e.key_ == null) {
                    return this.swapValue(e, value);
                }
                e = e.next_;
            }
        }
        this.ensureCapacity();
        index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
        this.mapTable[index] = e = new Entry<K, V>(hashCode, key, value, this.mapTable[index]);
        this.listTable[this.size++] = e;
        return null;
    }

    public final void set(int index, V value) {
        this.getEntry(index).setValue(value);
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this.removeMap(key);
        if (e != null) {
            Object value = e.value_;
            this.removeList(this.indexOf(e));
            e.clear();
            return value;
        }
        return null;
    }

    public final Object remove(int index) {
        Entry<K, V> e = this.removeList(index);
        Object value = e.value_;
        this.removeMap(e.key_);
        e.value_ = null;
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public final void clear() {
        int i;
        for (i = 0; i < this.mapTable.length; ++i) {
            this.mapTable[i] = null;
        }
        for (i = 0; i < this.listTable.length; ++i) {
            this.listTable[i] = null;
        }
        this.size = 0;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public final Object[] toArray(Object[] proto) {
        Object[] array = proto;
        if (proto.length < this.size) {
            array = (Object[])Array.newInstance(proto.getClass().getComponentType(), this.size);
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public final boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ArrayMap e = (ArrayMap)o;
        if (this.size != e.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i].equals(e.listTable[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new ArrayMapIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    int index = (entry.hashCode_ & Integer.MAX_VALUE) % ArrayMap.this.mapTable.length;
                    Entry e = ArrayMap.this.mapTable[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e.next_;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return ArrayMap.this.remove(entry.key_) != null;
                }

                @Override
                public int size() {
                    return ArrayMap.this.size;
                }

                @Override
                public void clear() {
                    ArrayMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.listTable.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.listTable[i].key_);
            out.writeObject(this.listTable[i].value_);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this.mapTable = new Entry[num];
        this.listTable = new Entry[num];
        this.threshold = (int)((float)num * 0.75f);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    @Override
    public Object clone() {
        ArrayMap<K, V> copy = new ArrayMap<K, V>();
        copy.threshold = this.threshold;
        copy.mapTable = this.mapTable;
        copy.listTable = this.listTable;
        copy.size = this.size;
        return copy;
    }

    private final int indexOf(Entry<K, V> entry) {
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i] != entry) continue;
            return i;
        }
        return -1;
    }

    private final Entry<K, V> removeMap(Object key) {
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            Entry<K, V> e = this.mapTable[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    if (prev != null) {
                        prev.next_ = e.next_;
                    } else {
                        this.mapTable[index] = e.next_;
                    }
                    return e;
                }
                prev = e;
                e = e.next_;
            }
        } else {
            Entry<K, V> e = this.mapTable[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.hashCode_ == hashCode && e.key_ == null) {
                    if (prev != null) {
                        prev.next_ = e.next_;
                    } else {
                        this.mapTable[index] = e.next_;
                    }
                    return e;
                }
                prev = e;
                e = e.next_;
            }
        }
        return null;
    }

    private final Entry<K, V> removeList(int index) {
        Entry<K, V> e = this.listTable[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.listTable, index + 1, this.listTable, index, numMoved);
        }
        this.listTable[--this.size] = null;
        return e;
    }

    private final void ensureCapacity() {
        if (this.size >= this.threshold) {
            Entry<K, V>[] oldTable = this.listTable;
            int newCapacity = oldTable.length * 2 + 1;
            Entry[] newMapTable = new Entry[newCapacity];
            Entry[] newListTable = new Entry[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.75f);
            System.arraycopy(oldTable, 0, newListTable, 0, this.size);
            for (int i = 0; i < this.size; ++i) {
                Entry<K, V> old = oldTable[i];
                int index = (old.hashCode_ & Integer.MAX_VALUE) % newCapacity;
                Entry<K, V> e = old;
                old = old.next_;
                e.next_ = newMapTable[index];
                newMapTable[index] = e;
            }
            this.mapTable = newMapTable;
            this.listTable = newListTable;
        }
    }

    private final V swapValue(Entry<K, V> entry, V value) {
        Object old = entry.value_;
        entry.value_ = value;
        return old;
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V>,
    Externalizable {
        private static final long serialVersionUID = -6625980241350717177L;
        transient int hashCode_;
        transient K key_;
        transient V value_;
        transient Entry<K, V> next_;

        public Entry(int hashCode, K key, V value, Entry<K, V> next) {
            this.hashCode_ = hashCode;
            this.key_ = key;
            this.value_ = value;
            this.next_ = next;
        }

        @Override
        public K getKey() {
            return this.key_;
        }

        @Override
        public V getValue() {
            return this.value_;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value_;
            this.value_ = value;
            return oldValue;
        }

        public void clear() {
            this.key_ = null;
            this.value_ = null;
            this.next_ = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Entry e = (Entry)o;
            return (this.key_ != null ? this.key_.equals(e.key_) : e.key_ == null) && (this.value_ != null ? this.value_.equals(e.value_) : e.value_ == null);
        }

        @Override
        public int hashCode() {
            return this.hashCode_;
        }

        public String toString() {
            return this.key_ + "=" + this.value_;
        }

        @Override
        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this.hashCode_);
            s.writeObject(this.key_);
            s.writeObject(this.value_);
            s.writeObject(this.next_);
        }

        @Override
        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this.hashCode_ = s.readInt();
            this.key_ = s.readObject();
            this.value_ = s.readObject();
            this.next_ = (Entry)s.readObject();
        }
    }

    private class ArrayMapIterator
    implements Iterator<Entry<K, V>> {
        private int current_ = 0;
        private int last_ = -1;

        private ArrayMapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current_ != ArrayMap.this.size;
        }

        @Override
        public Entry<K, V> next() {
            try {
                Entry n = ArrayMap.this.listTable[this.current_];
                this.last_ = this.current_++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.last_ == -1) {
                throw new IllegalStateException();
            }
            ArrayMap.this.remove(this.last_);
            if (this.last_ < this.current_) {
                --this.current_;
            }
            this.last_ = -1;
        }
    }
}

