/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.mock;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.t2framework.commons.mock.MockHttpServletRequest;
import org.t2framework.commons.mock.MockHttpServletRequestImpl;
import org.t2framework.commons.mock.MockRequestDispatcherImpl;
import org.t2framework.commons.mock.MockServletContext;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.ResourceUtil;

public class MockServletContextImpl
implements MockServletContext,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 5;
    public static final String SERVER_INFO = "mock";
    private String servletContextName;
    private final Map<String, String> mimeTypes = CollectionsUtil.newHashMap();
    private final Map<String, String> initParameters = CollectionsUtil.newHashMap();
    private final Map<String, Object> attributes = CollectionsUtil.newHashMap();

    public MockServletContextImpl(String path) {
        if (path == null || path.charAt(0) != '/') {
            path = "/";
        }
        this.servletContextName = path;
    }

    public ServletContext getContext(String path) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String file) {
        return this.mimeTypes.get(file);
    }

    @Override
    public void addMimeType(String file, String type) {
        this.mimeTypes.put(file, type);
    }

    public Set getResourcePaths(String path) {
        File file;
        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        File src = ResourceUtil.getResourceAsFile(".");
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        if (!(file = new File(root, this.adjustPath(path))).exists()) {
            int pos = path.lastIndexOf(47);
            if (pos != -1) {
                path = path.substring(pos + 1);
            }
            do {
                file = new File(root, path);
                root = root.getParentFile();
            } while (!file.exists() && root != null);
            path = "/" + path;
        }
        if (file.isDirectory()) {
            int len = file.getAbsolutePath().length();
            Set paths = CollectionsUtil.newHashSet();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String replace = files[i].getAbsolutePath().substring(len).replace('\\', '/');
                    paths.add(path + replace);
                }
                return paths;
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null) {
            return null;
        }
        path = this.adjustPath(path);
        File src = ResourceUtil.getResourceAsFile(".");
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        while (root != null) {
            File file = new File(root, path);
            if (file.exists()) {
                return file.toURL();
            }
            root = root.getParentFile();
        }
        if (ResourceUtil.isExist(path)) {
            return ResourceUtil.getResource(path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResource(path);
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if (path == null) {
            return null;
        }
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResourceAsStream(path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResourceAsStream(path);
        }
        return null;
    }

    protected String adjustPath(String path) {
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcherImpl(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    @Deprecated
    public void log(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace();
    }

    public String getRealPath(String path) {
        try {
            return ResourceUtil.getResource(this.adjustPath(path)).getFile();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new CollectionsUtil.IteratorEnumeration<String>(this.initParameters.keySet().iterator());
    }

    @Override
    public void setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new CollectionsUtil.IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    @Override
    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    @Override
    public MockHttpServletRequest createRequest(String path) {
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl(this, path);
        request.setQueryString(queryString);
        return request;
    }

    @Override
    public Map<String, String> getInitParameterMap() {
        return this.initParameters;
    }

    public String getContextPath() {
        return this.servletContextName;
    }
}

