/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.t2framework.commons.Constants;
import org.t2framework.commons.annotation.Composite;
import org.t2framework.commons.meta.AnnotationConfig;
import org.t2framework.commons.meta.LookupContext;
import org.t2framework.commons.meta.impl.AnnotationConfigImpl;
import org.t2framework.commons.meta.spi.AnnotationConfigCreator;
import org.t2framework.commons.util.AnnotationUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;

public class DefaultAnnotationConfigCreatorImpl
implements AnnotationConfigCreator {
    protected Class<? extends Annotation> compositeClass;
    protected Method compositeValueMethod;

    public DefaultAnnotationConfigCreatorImpl() {
        this(Composite.class);
    }

    public DefaultAnnotationConfigCreatorImpl(Class<? extends Annotation> compositeClass) {
        this.compositeClass = compositeClass;
        this.compositeValueMethod = Reflections.MethodUtil.getDeclaredMethod(compositeClass, "value", Constants.EMPTY_CLASS_ARRAY);
    }

    @Override
    public AnnotationConfig[] createAnnotationConfigs(Annotation annotation) {
        Assertion.notNull(annotation);
        boolean isComposite = this.isComposite(annotation);
        List<AnnotationConfig> retList = CollectionsUtil.newArrayList();
        Set<Class<? extends Annotation>> ignoreSet = CollectionsUtil.newHashSet();
        AnnotationConfig ad = this.createAnnotationConfig(annotation);
        if (isComposite && this.shouldInclude(annotation)) {
            retList.add(ad);
        } else if (!isComposite) {
            retList.add(ad);
        }
        ignoreSet.add(annotation.annotationType());
        if (!isComposite) {
            return this.toArray(retList);
        }
        return this.toArray(this.walkAnnotations(retList, ad, ignoreSet));
    }

    protected boolean shouldInclude(Annotation a) {
        Annotation composite = a.annotationType().getAnnotation(this.compositeClass);
        Composite.EvaluateType type = (Composite.EvaluateType)((Object)Reflections.MethodUtil.invoke(this.compositeValueMethod, composite, Constants.EMPTY_ARRAY));
        return type == Composite.EvaluateType.INCLUDE_THIS;
    }

    protected List<AnnotationConfig> walkAnnotations(List<AnnotationConfig> list, AnnotationConfig current, Set<Class<? extends Annotation>> ignoreSet) {
        for (Annotation meta : current.getMetaAnnotationList()) {
            Target target;
            boolean accept;
            Class<? extends Annotation> metaType = meta.annotationType();
            if (!this.shouldIgnore(meta) || ignoreSet.contains(metaType) || !(accept = this.shouldAccept(target = AnnotationUtil.getTargetAnnotation(meta), current))) continue;
            AnnotationConfig parent = this.createAnnotationConfig(meta);
            list.add(parent);
            if (this.isComposite(meta)) {
                ignoreSet.add(metaType);
            }
            if (current.hasLookup(metaType)) {
                LookupContext context = current.getLookupContext(metaType);
                parent.setValues(context);
            }
            this.walkAnnotations(list, parent, ignoreSet);
        }
        return list;
    }

    protected boolean shouldAccept(Target target, AnnotationConfig child) {
        if (target == null) {
            return true;
        }
        for (ElementType t : target.value()) {
            if (t == ElementType.ANNOTATION_TYPE || !child.isAcceptableType(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AnnotationConfig createAnnotationConfig(Annotation annotation) {
        return new AnnotationConfigImpl(annotation);
    }

    protected boolean shouldIgnore(Annotation a) {
        return a != null && a.annotationType() != this.compositeClass;
    }

    @Override
    public boolean isComposite(Annotation a) {
        Assertion.notNull(a);
        return a.annotationType().getAnnotation(this.compositeClass) != null;
    }

    protected AnnotationConfig[] toArray(List<AnnotationConfig> list) {
        return list.toArray(new AnnotationConfig[list.size()]);
    }
}

