/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.meta.PackageDesc;
import org.t2framework.commons.meta.PackageDescHolder;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.PatternUtil;

public class PackageDescHolderImpl
implements PackageDescHolder,
Disposable {
    protected List<PackageDesc> packageDescList = CollectionsUtil.newArrayList();
    protected Map<String, PackageCache> cache = CollectionsUtil.newHashMap();

    @Override
    public void addPackageDesc(PackageDesc packageDesc) {
        Assertion.notNull(packageDesc);
        Disposer.add(this);
        this.cache.clear();
        this.packageDescList.add(packageDesc);
    }

    @Override
    public PackageDesc getPackageDesc(String regex) {
        Assertion.notNull(regex);
        List<PackageDesc> list = this.getPackageDescList(regex);
        return list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public Iterator<PackageDesc> iterator() {
        return this.packageDescList.iterator();
    }

    @Override
    public Iterator<Class<?>> iteratorClasses(String regex) {
        PackageCache packageCache;
        Assertion.notNull(regex);
        if (this.cache.containsKey(regex) && (packageCache = this.cache.get(regex)) != null) {
            return packageCache.classesList.iterator();
        }
        packageCache = new PackageCache(regex);
        List classes = CollectionsUtil.newArrayList();
        for (PackageDesc pg : this.getPackageDescList(regex)) {
            List<Class<?>> classList = pg.getClassList();
            classes.addAll(classList);
            packageCache.classesList.addAll(classList);
        }
        return classes.iterator();
    }

    @Override
    public Iterator<PackageDesc> iteratorPackageDescs(String regex) {
        Assertion.notNull(regex);
        List<PackageDesc> list = this.getPackageDescList(regex);
        return list.iterator();
    }

    protected List<PackageDesc> getPackageDescList(String regex) {
        PackageCache packageCache;
        List<PackageDesc> list = CollectionsUtil.newArrayList();
        if (this.cache.containsKey(regex) && (packageCache = this.cache.get(regex)) != null) {
            return packageCache.packageDescList;
        }
        packageCache = new PackageCache(regex);
        Pattern pattern = PatternUtil.getPattern(regex);
        for (PackageDesc packageDesc : this.packageDescList) {
            String packageName = packageDesc.getPackageName();
            if (!pattern.matcher(packageName).matches()) continue;
            list.add(packageDesc);
            packageCache.packageDescList.add(packageDesc);
        }
        return list;
    }

    @Override
    public void dispose() {
        this.packageDescList.clear();
        this.cache.clear();
    }

    protected static class PackageCache {
        public List<PackageDesc> packageDescList = CollectionsUtil.newArrayList();
        public List<Class<?>> classesList = CollectionsUtil.newArrayList();
        public final String regex;

        public PackageCache(String regex) {
            this.regex = regex;
        }
    }
}

