/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta;

import java.util.Collection;
import java.util.Set;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class BeanDescUtil {
    public static <T> Iterable<ConfigContainer> getMethodConfigContainerList(BeanDesc<T> beanDesc) {
        Set<ConfigContainer> set = CollectionsUtil.newHashSet();
        set.addAll(beanDesc.getAllMethodDesc());
        set.addAll(beanDesc.getAllPropertyDesc());
        return set;
    }

    public static <T> Iterable<ConfigContainer> getMethodConfigContainerList(BeanDesc<T> beanDesc, Class<?> ... types) {
        Set<ConfigContainer> set = CollectionsUtil.newHashSet();
        for (MethodDesc methodDesc : beanDesc.getAllMethodDesc()) {
            BeanDescUtil.addTypeMatchedConfigContainer(set, (ConfigContainer)methodDesc, types);
        }
        for (PropertyDesc propertyDesc : beanDesc.getAllPropertyDesc()) {
            if (propertyDesc.isReadable()) {
                BeanDescUtil.addTypeMatchedConfigContainer(set, (ConfigContainer)propertyDesc.getReadMethodDesc(), types);
            }
            if (!propertyDesc.isWritable()) continue;
            BeanDescUtil.addTypeMatchedConfigContainer(set, (ConfigContainer)propertyDesc.getWriteMethodDesc(), types);
        }
        return set;
    }

    protected static void addTypeMatchedConfigContainer(Collection<ConfigContainer> list, ConfigContainer container, Class<?> ... types) {
        Assertion.notNull(list);
        Assertion.notNull(container);
        Assertion.notNulls(types);
        for (int i = 0; i < types.length; ++i) {
            BeanDescUtil.addTypeMatchedConfigContainer(list, container, types[i]);
        }
    }

    protected static void addTypeMatchedConfigContainer(Collection<ConfigContainer> list, ConfigContainer container, Class<?> type) {
        for (Config cd : container) {
            if (!cd.getType().equals(type)) continue;
            list.add(container);
            break;
        }
    }
}

