/*
 * Decompiled with CFR 0.152.
 */
package winstone.tools;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import winstone.Launcher;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;

public class WinstoneControl {
    private static final WinstoneResourceBundle TOOLS_RESOURCES = new WinstoneResourceBundle("winstone.tools.LocalStrings");
    static final String OPERATION_SHUTDOWN = "shutdown";
    static final String OPERATION_RELOAD = "reload:";
    static int TIMEOUT = 10000;

    public static void main(String[] argv) throws Exception {
        Map options = Launcher.loadArgsFromCommandLineAndConfig(argv, "operation");
        String operation = (String)options.get("operation");
        if (options.containsKey("controlPort") && !options.containsKey("port")) {
            options.put("port", options.get("controlPort"));
        }
        if (operation.equals("")) {
            WinstoneControl.printUsage();
            return;
        }
        Logger.setCurrentDebugLevel(Integer.parseInt(WebAppConfiguration.stringArg(options, "debug", "5")));
        String host = WebAppConfiguration.stringArg(options, "host", "localhost");
        String port = WebAppConfiguration.stringArg(options, "port", "8081");
        Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.UsingHostPort", new String[]{host, port});
        if (operation.equalsIgnoreCase(OPERATION_SHUTDOWN)) {
            Socket socket = new Socket(host, Integer.parseInt(port));
            socket.setSoTimeout(TIMEOUT);
            OutputStream out = socket.getOutputStream();
            out.write(48);
            out.close();
            Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.ShutdownOK", new String[]{host, port});
        } else if (operation.toLowerCase().startsWith(OPERATION_RELOAD.toLowerCase())) {
            String webappName = operation.substring(OPERATION_RELOAD.length());
            Socket socket = new Socket(host, Integer.parseInt(port));
            socket.setSoTimeout(TIMEOUT);
            OutputStream out = socket.getOutputStream();
            out.write(52);
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeUTF(host);
            objOut.writeUTF(webappName);
            objOut.close();
            out.close();
            Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.ReloadOK", new String[]{host, port});
        } else {
            WinstoneControl.printUsage();
        }
    }

    private static void printUsage() throws IOException {
        System.out.println(TOOLS_RESOURCES.getString("WinstoneControl.Usage"));
    }
}

