/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.util;

import javax.servlet.http.HttpServletRequest;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.contexts.Request;

public class PathUtil {
    public static String getPagePath(Request request) {
        HttpServletRequest req = (HttpServletRequest)request.getNativeResource();
        String requestUri = PathUtil.removalJSessionId(req.getRequestURI());
        String contextPath = req.getContextPath();
        int index = requestUri.indexOf(contextPath);
        String path = null;
        path = index >= 0 ? requestUri.substring(index + contextPath.length(), requestUri.length()) : requestUri;
        return PathUtil.startsWithSlash(path) ? path.substring(1) : path;
    }

    public static String getActionMethodDescPath(Request request, String pagePath) {
        String testPath;
        Assertion.notNull((Object)pagePath);
        String path = PathUtil.getPagePath(request);
        String string = testPath = PathUtil.startsWithSlash(pagePath) ? pagePath.substring(1) : pagePath;
        if (path.indexOf(testPath) == 0) {
            return path.substring(testPath.length(), path.length());
        }
        return path;
    }

    public static String appendStartSlashIfNeed(String path) {
        if (path != null && !PathUtil.startsWithSlash(path)) {
            return "/" + path;
        }
        return path;
    }

    public static String appendEndSlashIfNeed(String path) {
        if (path != null && !PathUtil.endsWithSlash(path)) {
            return path + "/";
        }
        return path;
    }

    public static String removeStartSlashIfNeed(String path) {
        if (path != null && PathUtil.startsWithSlash(path)) {
            return path.substring(1, path.length());
        }
        return path;
    }

    public static String removeEndSlashIfNeed(String path) {
        if (path != null && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean startsWithSlash(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        return path.indexOf("/") == 0;
    }

    public static boolean endsWithSlash(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        return path.lastIndexOf("/") == path.length() - 1;
    }

    public static String removalJSessionId(String path) {
        int idx = path.indexOf(59);
        if (0 <= idx) {
            return path.substring(0, idx);
        }
        return path;
    }
}

