/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.navigation;

import java.util.Map;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.util.JavaBeansUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.commons.util.UrlBuilder;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.InvalidClientCodeRuntimeException;
import org.t2framework.t2.navigation.Redirect;
import org.t2framework.t2.navigation.WebNavigation;
import org.t2framework.t2.util.PathUtil;

public class Forward
extends WebNavigation {
    private static Logger logger = Logger.getLogger(Redirect.class);

    public static Forward to(Class<?> pageClass) {
        return new Forward(pageClass);
    }

    public static Forward to(String path) {
        return new Forward(path);
    }

    public Forward(String path) {
        super(path);
    }

    public Forward(Class<?> pageClass) {
        super(pageClass);
    }

    @Override
    public void execute(WebContext context) throws Exception {
        String path = null;
        if (this.pageClass != null) {
            Config cd = this.classDesc.findConfig(Page.class);
            if (cd == null || !cd.hasAnnotation()) {
                logger.log("WTDT0019", null, new Object[]{this.getPageClass()});
                throw new InvalidClientCodeRuntimeException();
            }
            Page page = (Page)cd.getAnnotation();
            path = page.value();
            if (StringUtil.isEmpty((String)path)) {
                path = PathUtil.appendStartSlashIfNeed(JavaBeansUtil.decapitalize((String)this.pageClass.getSimpleName()));
            }
        } else {
            path = this.getPath();
            if (!path.startsWith("/")) {
                logger.log("ITDT0020", null, new Object[]{"Forward"});
                path = PathUtil.appendStartSlashIfNeed(path);
            }
        }
        String realpath = this.buildForwardPath(context, path);
        this.forward(context, realpath);
    }

    protected String buildForwardPath(WebContext context, String path) {
        UrlBuilder builder = new UrlBuilder(path);
        Map<String, Object> params = ((Request)context.getRequest()).getAttributesAsMap();
        if (!params.isEmpty()) {
            builder.addAll(params);
        }
        return builder.build();
    }

    protected void forward(WebContext context, String path) {
        context.forward(path);
    }
}

