/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.mock;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.mock.MockFilterConfig;
import org.t2framework.commons.mock.MockFilterConfigImpl;
import org.t2framework.commons.mock.MockHttpServletRequest;
import org.t2framework.commons.mock.MockHttpServletRequestImpl;
import org.t2framework.commons.mock.MockHttpServletResponse;
import org.t2framework.commons.mock.MockHttpServletResponseImpl;
import org.t2framework.commons.mock.MockHttpSession;
import org.t2framework.commons.mock.MockServletContext;
import org.t2framework.commons.mock.MockServletContextImpl;
import org.t2framework.t2.contexts.Application;
import org.t2framework.t2.contexts.Chain;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.Session;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.ApplicationImpl;
import org.t2framework.t2.contexts.impl.RequestImpl;
import org.t2framework.t2.contexts.impl.ResponseImpl;
import org.t2framework.t2.contexts.impl.SessionImpl;

public class MockWebContext
extends WebContext {
    protected Request request;
    protected Response response;
    protected Application application;
    protected Session session;
    protected MockHttpServletRequest mockRequest;
    protected MockHttpServletResponse mockResponse;
    protected MockServletContext mockServletContext;
    protected MockHttpSession mockSession;

    public static MockWebContext createMock(String requestPath) {
        return MockWebContext.createMock(null, requestPath);
    }

    public static MockWebContext createMock(String path, String requestPath) {
        MockServletContextImpl context = new MockServletContextImpl(path);
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)context, requestPath);
        MockHttpServletResponseImpl response = new MockHttpServletResponseImpl((HttpServletRequest)request);
        MockHttpSession session = (MockHttpSession)MockHttpSession.class.cast(request.getSession());
        MockFilterConfigImpl config = new MockFilterConfigImpl((MockServletContext)context);
        MockWebContext mock = new MockWebContext((MockHttpServletRequest)request, (MockHttpServletResponse)response, (MockServletContext)context, session, (MockFilterConfig)config);
        WebContext.set(mock);
        return mock;
    }

    public MockWebContext(MockHttpServletRequest req, MockHttpServletResponse res, MockServletContext context, MockHttpSession ses, MockFilterConfig config) {
        this.request = new RequestImpl((HttpServletRequest)req, (HttpServletResponse)res, true);
        this.response = new ResponseImpl((HttpServletResponse)res);
        this.application = new ApplicationImpl((ServletContext)context, (FilterConfig)config);
        this.session = new SessionImpl(this.request);
        this.mockRequest = req;
        this.mockResponse = res;
        this.mockSession = ses;
        this.mockServletContext = context;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public MockHttpServletRequest getMockHttpServletRequest() {
        return this.mockRequest;
    }

    public MockHttpServletResponse getMockHttpServletResponse() {
        return this.mockResponse;
    }

    public MockHttpSession getMockHttpSession() {
        return this.mockSession;
    }

    public MockServletContext getMockServletContext() {
        return this.mockServletContext;
    }

    @Override
    public Chain getChain() {
        return null;
    }
}

