/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.handler.impl;

import java.util.List;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.ExceptionHandlerCyclicRuntimeException;
import org.t2framework.t2.exception.ExceptionHandlerUnprocessingRuntimeException;
import org.t2framework.t2.handler.ExceptionHandler;
import org.t2framework.t2.handler.ExceptionHandlerChain;
import org.t2framework.t2.spi.Navigation;

public class ExceptionHandlerChainImpl
implements ExceptionHandlerChain {
    protected final List<ExceptionHandler<Throwable, Exception>> exceptionHandlers;

    public ExceptionHandlerChainImpl(List<ExceptionHandler<Throwable, Exception>> exceptionHandlers) {
        this.exceptionHandlers = (List)Assertion.notNull(exceptionHandlers);
    }

    @Override
    public Navigation doChain(Throwable t, WebContext context) {
        Throwable target = t;
        Navigation n = null;
        Exception cyclic = null;
        for (ExceptionHandler<Throwable, Exception> handler : this.exceptionHandlers) {
            if (!handler.isTargetException(target)) continue;
            try {
                n = handler.handleException(t, context);
            }
            catch (Exception e) {
                if (e.equals(cyclic)) {
                    throw new ExceptionHandlerCyclicRuntimeException(target);
                }
                target = e;
                cyclic = e;
                n = null;
                continue;
            }
            if (n == null) continue;
            break;
        }
        if (n == null && target != t) {
            throw new ExceptionHandlerUnprocessingRuntimeException(target);
        }
        return n;
    }
}

