/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.contexts.Application;

public class ApplicationImpl
implements Application {
    protected ServletContext servletContext;
    protected Map<String, String> filterInitParamMap;

    public ApplicationImpl(ServletContext servletContext, FilterConfig config) {
        Assertion.notNulls((Object[])new Object[]{servletContext, config});
        this.servletContext = servletContext;
        this.initFilterInitParamMap(config);
    }

    protected void initFilterInitParamMap(FilterConfig config) {
        HashMap map = CollectionsUtil.newHashMap();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = config.getInitParameter(name);
            map.put(name, value);
        }
        this.filterInitParamMap = map;
    }

    @Override
    public String getInitParameter(String key) {
        return this.servletContext.getInitParameter(key);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    @Override
    public List<String> getAttributeNames() {
        List ret = CollectionsUtil.newArrayList();
        Enumeration e = this.getNativeResource().getAttributeNames();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret;
    }

    @Override
    public Map<String, Object> getAttributesAsMap() {
        HashMap ret = CollectionsUtil.newHashMap();
        Enumeration e = this.getNativeResource().getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.servletContext.getAttribute(key);
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public <V> V getAttribute(String key) {
        return (V)this.getNativeResource().getAttribute(key);
    }

    @Override
    public synchronized <V> V removeAttribute(String key) {
        V ret = this.getAttribute(key);
        this.getNativeResource().removeAttribute(key);
        return ret;
    }

    @Override
    public synchronized <V> void setAttribute(String key, V value) {
        this.getNativeResource().setAttribute(key, value);
    }

    @Override
    public ServletContext getNativeResource() {
        return this.servletContext;
    }

    @Override
    public Map<String, String> getFilterInitParamMap() {
        return this.filterInitParamMap;
    }

    @Override
    public String getFilterInitParamValue(String name) {
        return this.filterInitParamMap.get(Assertion.notNull((Object)name));
    }

    @Override
    public String getRootPackage() {
        return this.filterInitParamMap.get("t2.rootpackage");
    }
}

