/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ErrorInfo;
import org.t2framework.t2.action.impl.AbstractParameterResolver;
import org.t2framework.t2.annotation.core.Form;
import org.t2framework.t2.contexts.Request;

public class FormParameterResolver
extends AbstractParameterResolver {
    public FormParameterResolver() {
        this.setTargetAnnotationClass(Form.class);
    }

    @Override
    public Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        Form form = (Form)this.findTargetAnnotation(paramAnnotations, this.targetAnnotationClass);
        if (form == null) {
            throw new IllegalStateException("@Form must not be null.");
        }
        ErrorInfo errorInfo = actionContext.getErrorInfo();
        Request request = actionContext.getRequest();
        String className = paramClass.getName();
        Object o = null;
        try {
            o = Reflections.ClassUtil.newInstance(paramClass);
        }
        catch (Throwable t) {
            errorInfo.addErrorInfo(className, t);
            return null;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Object)o);
        for (PropertyDesc pd : beanDesc.getAllPropertyDesc()) {
            String name = pd.getPropertyName();
            if (!request.hasMultipleParameters(name)) {
                String param = request.getParameter(name);
                try {
                    pd.setValue(o, (Object)param);
                }
                catch (Throwable t) {
                    errorInfo.addErrorInfo(className + "#" + name, t);
                }
                continue;
            }
            String[] params = request.getParameters(name);
            if (params == null) continue;
            try {
                pd.setValue(o, (Object)params);
            }
            catch (Throwable t) {
                errorInfo.addErrorInfo(className + "#" + name + "[]", t);
            }
        }
        return o;
    }
}

