/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.exception.InvocationTargetRuntimeException;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ActionContextBuilder;
import org.t2framework.t2.action.ActionInvoker;
import org.t2framework.t2.action.PageDescFinder;
import org.t2framework.t2.action.PageDescFinderFactory;
import org.t2framework.t2.action.ParameterResolver;
import org.t2framework.t2.action.impl.ActionContextBuilderImpl;
import org.t2framework.t2.action.impl.ActionContextImpl;
import org.t2framework.t2.action.impl.ErrorInfoImpl;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.ExceptionHandlerUnprocessingRuntimeException;
import org.t2framework.t2.exception.NoParameterResolverRuntimeException;
import org.t2framework.t2.handler.ExceptionHandlerChain;
import org.t2framework.t2.handler.impl.ExceptionHandlerChainImpl;
import org.t2framework.t2.navigation.PassThrough;
import org.t2framework.t2.plugin.AbstractPlugin;
import org.t2framework.t2.plugin.PluginProcessor;
import org.t2framework.t2.spi.AnnotationResolverCreator;
import org.t2framework.t2.spi.Navigation;

public class ActionInvokerImpl
implements ActionInvoker {
    protected WebContext context;
    protected Map<String, PageDesc> pageDescMap;
    protected PageDesc targetPageDesc = null;
    protected Class pageClass = null;
    protected ActionContextBuilder builder;
    protected Object lock = new Object();
    protected final ContainerAdapter<?> containerAdapter;
    protected final AnnotationResolverCreator resolverCreator;
    protected final PluginProcessor pluginProcessor;
    protected ExceptionHandlerChain exceptionHandlerChain;
    protected static Logger log = Logger.getLogger(ActionInvokerImpl.class);
    protected List<ParameterResolver> parameterResolvers = CollectionsUtil.emptyList();

    public ActionInvokerImpl(WebContext context, Map<String, PageDesc> pageDescMap, ContainerAdapter<?> containerAdapter, AnnotationResolverCreator resolverCreator, PluginProcessor pluginProcessor) {
        this.context = context;
        this.pageDescMap = pageDescMap;
        this.containerAdapter = (ContainerAdapter)Assertion.notNull(containerAdapter);
        this.resolverCreator = (AnnotationResolverCreator)Assertion.notNull((Object)resolverCreator);
        this.pluginProcessor = (PluginProcessor)Assertion.notNull((Object)pluginProcessor);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        ActionContext actionContext = this.createActionContext(this.context);
        ActionInvokerImpl actionInvokerImpl = this;
        synchronized (actionInvokerImpl) {
            PageDescFinder pageDescFinder = PageDescFinderFactory.getPageDescFinder(this.context, this.pageDescMap);
            if (pageDescFinder != null) {
                PageDesc pd = pageDescFinder.find(this.context, this.pageDescMap);
                if (pd == null) {
                    return;
                }
                log.log("ITDT0020", null, new Object[]{pd.getPageName()});
                this.targetPageDesc = pd;
                this.pageClass = this.targetPageDesc.getPageClassDesc().getComponentClass();
                actionContext.setTargetPageDesc(pd);
            }
        }
        this.exceptionHandlerChain = new ExceptionHandlerChainImpl(this.containerAdapter.createExceptionHandlers());
        this.parameterResolvers = this.resolverCreator.createParameterResolvers(this.containerAdapter, this.context);
        this.builder = new ActionContextBuilderImpl(this.resolverCreator.createActionAnnotationResolvers(this.containerAdapter), this.resolverCreator.createDefaultActionAnnotationResolver(this.containerAdapter));
    }

    protected ActionContext createActionContext(WebContext context) {
        ActionContextImpl actionContext = new ActionContextImpl(context);
        context.setActionContext(actionContext);
        return actionContext;
    }

    @Override
    public boolean match() {
        return this.targetPageDesc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Navigation invoke() {
        Navigation ret = null;
        try {
            ActionContext actionContext = this.context.getActionContext();
            if (actionContext == null) {
                return PassThrough.pass();
            }
            this.builder.build(actionContext);
            MethodDesc actionMethod = actionContext.getTargetMethodDesc();
            if (actionMethod == null) {
                return PassThrough.pass();
            }
            Object page = this.getPage();
            ret = this.invokeComponentCreated(page);
            if (this.isNavigateImmediatelly(ret)) {
                return ret;
            }
            this.saveRequestParameters((Request)this.context.getRequest());
            Object[] args = this.prepareArguments(actionContext, actionMethod);
            try {
                ret = this.beforeActionInvoke(actionContext, page, actionMethod, args);
                if (this.isNavigateImmediatelly(ret)) {
                    Navigation navigation = ret;
                    return navigation;
                }
                ret = this.invokeAction(actionContext, page, actionMethod, args);
            }
            finally {
                Navigation n = this.afterActionInvoke(actionContext, page, actionMethod, args);
                if (this.isNavigateImmediatelly(n)) {
                    ret = n;
                }
            }
            if (ret != null) return ret;
            return PassThrough.pass();
        }
        catch (Throwable t) {
            Navigation n = null;
            n = this.exceptionHandlerChain.doChain(t, this.context);
            if (n != null) {
                return n;
            }
            if (!(t instanceof RuntimeException)) throw new ExceptionHandlerUnprocessingRuntimeException(t);
            throw (RuntimeException)t;
        }
    }

    protected void saveRequestParameters(Request request) {
        for (String paramKey : request.getParameterNames()) {
            request.setAttribute(paramKey, request.getParameter(paramKey));
        }
    }

    protected boolean isNavigateImmediatelly(Navigation navigation) {
        return navigation != null && !navigation.equals(AbstractPlugin.PluginDefaultNavigation.INSTANCE);
    }

    protected Navigation invokeComponentCreated(Object page) {
        return this.pluginProcessor.invokeComponentCreated(this.context, page);
    }

    protected Navigation beforeActionInvoke(ActionContext actionContext, Object page, MethodDesc methodDesc, Object[] args) {
        return this.pluginProcessor.beforeActionInvoke(actionContext, methodDesc, page, args);
    }

    protected Navigation invokeAction(ActionContext actionContext, Object page, MethodDesc methodDesc, Object[] args) {
        try {
            return (Navigation)methodDesc.invoke(page, args);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(t);
        }
    }

    protected Navigation afterActionInvoke(ActionContext actionContext, Object page, MethodDesc methodDesc, Object[] args) {
        return this.pluginProcessor.afterActionInvoke(actionContext, methodDesc, page, args);
    }

    protected Object[] prepareArguments(ActionContext actionContext, MethodDesc methodDesc) throws NoParameterResolverRuntimeException {
        Class[] paramClasses = methodDesc.getParameterTypes();
        Annotation[][] parameterAnnotations = methodDesc.getParameterAnnotations();
        Object[] args = new Object[paramClasses.length];
        ErrorInfoImpl errorInfo = new ErrorInfoImpl();
        actionContext.setErrorInfo(errorInfo);
        for (int paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
            ParameterResolver resolver2;
            Class argType;
            Annotation[] argAnnotations;
            block2: {
                argAnnotations = parameterAnnotations[paramIndex];
                argType = paramClasses[paramIndex];
                for (ParameterResolver resolver2 : this.parameterResolvers) {
                    if (!resolver2.isTargetParameter(actionContext, methodDesc, paramIndex, argAnnotations, argType)) continue;
                    break block2;
                }
                throw new NoParameterResolverRuntimeException(argType);
            }
            args[paramIndex] = resolver2.resolve(actionContext, methodDesc, paramIndex, argAnnotations, argType);
        }
        actionContext.clearErrorInfo();
        return args;
    }

    protected Throwable unwrapIfInvocationTargetRuntimeException(Throwable t) {
        if (t instanceof InvocationTargetRuntimeException) {
            return t.getCause();
        }
        return t;
    }

    protected Object getPage() {
        return this.containerAdapter.getComponent(this.pageClass);
    }

    @Override
    public void setActionContextBuilder(ActionContextBuilder creator) {
        this.builder = (ActionContextBuilder)Assertion.notNull((Object)creator);
    }
}

