/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ErrorInfo;
import org.t2framework.t2.annotation.core.Default;
import org.t2framework.t2.contexts.ActionMethodDesc;
import org.t2framework.t2.contexts.Application;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.Session;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.NoTargetPageDescFoundRuntimeException;
import org.t2framework.t2.util.UrlTemplate;

public class ActionContextImpl
implements ActionContext {
    protected PageDesc targetPageDesc;
    protected MethodDesc targetMethodDesc;
    protected final WebContext context;
    protected int matchCount = 0;
    protected Object body;
    protected Map<MethodDesc, List<UrlTemplate>> templatesMap = CollectionsUtil.newHashMap();
    protected ErrorInfo errorInfo;

    public ActionContextImpl(WebContext context) {
        this.context = context;
    }

    public ActionContextImpl(WebContext context, PageDesc targetPageDesc) {
        this.context = context;
        this.setTargetPageDesc(targetPageDesc);
    }

    @Override
    public void setTargetPageDesc(PageDesc targetPageDesc) {
        this.targetPageDesc = targetPageDesc;
    }

    protected ActionMethodDesc getActionMethodDesc() {
        return this.getTargetPageDesc().getActionMethodDesc();
    }

    @Override
    public PageDesc getTargetPageDesc() {
        if (this.targetPageDesc == null) {
            throw new NoTargetPageDescFoundRuntimeException();
        }
        return this.targetPageDesc;
    }

    @Override
    public Set<String> getMethodNameSet() {
        return this.getActionMethodDesc().getMethodNameList();
    }

    @Override
    public MethodDesc getMethodDesc(String methodName) {
        return this.getActionMethodDesc().getMethodDesc(methodName);
    }

    @Override
    public MethodDesc getTargetMethodDesc() {
        return this.targetMethodDesc;
    }

    @Override
    public synchronized void setTargetMethodDesc(MethodDesc methodDesc) {
        this.targetMethodDesc = methodDesc;
    }

    @Override
    public String getPageTemplatePath() {
        return this.getTargetPageDesc().getPageTemplatePath();
    }

    @Override
    public Request getRequest() {
        return (Request)this.context.getRequest();
    }

    @Override
    public void incrementMatchCount() {
        ++this.matchCount;
    }

    @Override
    public void clearMatchCount() {
        this.matchCount = 0;
    }

    @Override
    public int getMatchCount() {
        return this.matchCount;
    }

    @Override
    public void addUrlTemplate(MethodDesc methodDesc, UrlTemplate template) {
        Assertion.notNull((Object)methodDesc);
        Assertion.notNull((Object)template);
        List list = this.templatesMap.get(methodDesc);
        if (list == null) {
            list = CollectionsUtil.newArrayList();
        }
        list.add(template);
        this.templatesMap.put(methodDesc, list);
    }

    @Override
    public UrlTemplate[] getUrlTemplates() {
        return this.getUrlTemplates(this.targetMethodDesc);
    }

    @Override
    public UrlTemplate[] getUrlTemplates(MethodDesc methodDesc) {
        List<UrlTemplate> templates = this.templatesMap.get(methodDesc);
        if (templates == null) {
            return null;
        }
        return templates.toArray(new UrlTemplate[0]);
    }

    @Override
    public MethodDesc getDefaultMethodDesc() {
        return this.getTargetPageDesc().getDefaultMethodDesc();
    }

    @Override
    public boolean hasDefaultMethodDesc() {
        return this.getTargetPageDesc().hasDefaultMethodDesc();
    }

    @Override
    public Response getResponse() {
        return (Response)this.context.getResponse();
    }

    @Override
    public Session getSession() {
        return (Session)this.context.getSession();
    }

    @Override
    public Application getApplication() {
        return (Application)this.context.getApplication();
    }

    @Override
    public Annotation getDefaultAnnotation() {
        Config config = this.getDefaultMethodDesc().findConfig(Default.class);
        if (config == null) {
            return null;
        }
        return config.getAnnotation();
    }

    @Override
    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = (ErrorInfo)Assertion.notNull((Object)errorInfo);
    }

    @Override
    public void clearErrorInfo() {
        this.errorInfo = null;
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }
}

