/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ParameterResolver;

public abstract class AbstractParameterResolver
implements ParameterResolver {
    protected Class<?> targetClass;
    protected Class<?> targetAnnotationClass;

    @Override
    public boolean isTargetParameter(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        Annotation annotation;
        Assertion.notNulls((Object[])new Serializable[]{paramAnnotations, paramClass});
        if (this.targetAnnotationClass != null && (annotation = (Annotation)this.findTargetAnnotation(paramAnnotations, this.targetAnnotationClass)) != null) {
            return true;
        }
        return this.targetClass != null && this.targetClass == paramClass;
    }

    protected <A> A findTargetAnnotation(Annotation[] annotations, Class<?> targetAnnotationClass) {
        Assertion.notNulls((Object[])new Serializable[]{annotations, targetAnnotationClass});
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != targetAnnotationClass) continue;
            return (A)annotation;
        }
        return null;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetAnnotationClass(Class<?> targetAnnotationClass) {
        this.targetAnnotationClass = targetAnnotationClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Class<?> getTargetAnnotationClass() {
        return this.targetAnnotationClass;
    }
}

