/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVariableResolverFactory
implements VariableResolverFactory {
    protected Map<String, VariableResolver> variableResolvers;
    protected VariableResolverFactory nextFactory;
    protected String[] indexedVariableNames;
    protected VariableResolver[] indexedVariableResolvers;

    @Override
    public VariableResolverFactory getNextFactory() {
        return this.nextFactory;
    }

    @Override
    public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
        this.nextFactory = resolverFactory;
        return this.nextFactory;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.isResolveable(name)) {
            if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
                return this.variableResolvers.get(name);
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    public boolean isNextResolveable(String name) {
        return this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    public void appendFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            VariableResolverFactory vrf = this.nextFactory;
            while (vrf.getNextFactory() != null) {
                vrf = vrf.getNextFactory();
            }
            vrf.setNextFactory(this.nextFactory);
        }
    }

    public void insertFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            this.nextFactory = resolverFactory;
            resolverFactory.setNextFactory(this.nextFactory);
        }
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variableResolvers != null) {
                return new HashSet<String>(this.variableResolvers.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variableResolvers != null) {
            return new HashSet<String>(this.variableResolvers.keySet());
        }
        return new HashSet<String>(0);
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(index, name, value);
        }
        throw new RuntimeException("cannot create indexed variable: " + name + "(" + index + "). operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        if (this.nextFactory != null) {
            return this.nextFactory.getIndexedVariableResolver(index);
        }
        throw new RuntimeException("cannot access indexed variable: " + index + ".  operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(index, name, value, type);
        }
        throw new RuntimeException("cannot access indexed variable: " + name + "(" + index + ").  operation not supported by resolver.: " + this.getClass().getName());
    }

    public Map<String, VariableResolver> getVariableResolvers() {
        return this.variableResolvers;
    }

    public void setVariableResolvers(Map<String, VariableResolver> variableResolvers) {
        this.variableResolvers = variableResolvers;
    }

    public String[] getIndexedVariableNames() {
        return this.indexedVariableNames;
    }

    public void setIndexedVariableNames(String[] indexedVariableNames) {
        this.indexedVariableNames = indexedVariableNames;
    }

    @Override
    public int variableIndexOf(String name) {
        for (int i = 0; i < this.indexedVariableNames.length; ++i) {
            if (!name.equals(this.indexedVariableNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public VariableResolver setIndexedVariableResolver(int index, VariableResolver resolver) {
        if (this.indexedVariableResolvers == null) {
            this.indexedVariableResolvers = new VariableResolver[this.indexedVariableNames.length];
        }
        this.indexedVariableResolvers[index] = resolver;
        return this.indexedVariableResolvers[index];
    }

    @Override
    public boolean isIndexedFactory() {
        return false;
    }
}

