#include <windows.h>
#include <stdio.h>
#include <shlobj.h>
#include <jni.h>

JNIEnv* CreateJavaVM();
void    DestroyJavaVM();
JNIEnv* AttachJavaVM();
void    DetachJavaVM();

LPTSTR  GetArgsOpt(LPTSTR vm_args_opt);
void    AddPath(LPCTSTR path);
void    Initialize();
LPTSTR  GetModulePath(LPTSTR buffer, DWORD size);
LPTSTR	GetModuleVersion(LPTSTR buffer);
BOOL    IsDirectory(LPTSTR path);
LPTSTR  lstrrchr(LPTSTR source, TCHAR c);

typedef jint (WINAPI* JNIGetDefaultJavaVMInitArgs)(JavaVMInitArgs*);
typedef jint (WINAPI* JNICreateJavaVM)(JavaVM**, void**, JavaVMInitArgs*);

JavaVM* jvm;
JNIEnv* env;

TCHAR   opt_app_path[MAX_PATH + 32];
TCHAR   opt_app_name[MAX_PATH + 32];
TCHAR	opt_app_version[64];
TCHAR   opt_policy_path[MAX_PATH + 32];
TCHAR   binpath[MAX_PATH];
TCHAR   jvmpath[MAX_PATH];
TCHAR   classpath[2048];
TCHAR   extdirs[2048];
TCHAR	libpath[2048];
HMODULE jvmdll;

JNIEnv* CreateJavaVM(LPTSTR vm_args_opt) {
	Initialize();
	
	AddPath(binpath);
	AddPath(jvmpath);
	
	if((jvmdll = LoadLibrary("jvm.dll")) == NULL) {
		return NULL;
	}
	
	JNIGetDefaultJavaVMInitArgs getDefaultJavaVMInitArgs = (JNIGetDefaultJavaVMInitArgs)GetProcAddress(jvmdll, "JNI_GetDefaultJavaVMInitArgs");
	JNICreateJavaVM createJavaVM = (JNICreateJavaVM)GetProcAddress(jvmdll, "JNI_CreateJavaVM");
	
	JavaVMOption options[64];
	options[0].optionString = "-Dawt.toolkit=Toolkit";
	options[1].optionString = opt_app_path;
	options[2].optionString = opt_app_name;
	options[3].optionString = opt_app_version;
	options[4].optionString = classpath;
	options[5].optionString = extdirs;
	options[6].optionString = libpath;
	
	JavaVMInitArgs vm_args;
	vm_args.version = JNI_VERSION_1_2;
	vm_args.options = options;
	vm_args.nOptions = 7;
	vm_args.ignoreUnrecognized = 1;
	
	if(opt_policy_path[0] != 0x00) {
		options[vm_args.nOptions++].optionString = "-Djava.security.manager";
		options[vm_args.nOptions++].optionString = opt_policy_path;
	}
	
	LPTSTR a;
	while((a = GetArgsOpt(vm_args_opt)) != NULL) {
		options[vm_args.nOptions++].optionString = a;
	}
	
	getDefaultJavaVMInitArgs(&vm_args);
	createJavaVM(&jvm, (void**)&env, &vm_args);
	
	return env;
}

LPTSTR GetArgsOpt(LPTSTR vm_args_opt) {
	static LPTSTR sp;
	static LPTSTR p;
	LPTSTR ret;
	
	if((sp == NULL) && (p == NULL)) {
		sp = vm_args_opt;
	}
	p = sp;
	if(sp == NULL) {
		return NULL;
	}
	for(;;) {
		if(*p == 0x00) {
			if(p > sp) {
				ret = sp;
				sp = NULL;
				return ret;
			} else {
				return NULL;
			}
		} else if((*p == ' ') && (*(p+1) == '-')) {
			*p = 0x00;
			ret = sp;
			sp = p + 1;
			return ret;
		} else {
			p++;
		}
	}
}

void DestroyJavaVM() {
	if(jvm != NULL) {
		jvm->DestroyJavaVM();
	}
}

JNIEnv* AttachJavaVM() {
	JNIEnv* env;
	if(jvm->AttachCurrentThread((void**)&env, NULL) == 0) {
		return env;
	}
	return NULL;
}

void DetachJavaVM() {
	jvm->DetachCurrentThread();	
}

void Initialize() {
	HKEY  key;
	char  buffer[2048];
	DWORD size = MAX_PATH;
	char  subkey[128] = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
	
	binpath[0] = '\0';
	jvmpath[0] = '\0';
	extdirs[0] = '\0';
	libpath[0] = '\0';
	
	TCHAR jre1[MAX_PATH+1];
	TCHAR jre2[MAX_PATH+1];
	TCHAR jre3[MAX_PATH+1];
	
	lstrcpy(opt_app_version, "-Djava.application.version=");
	lstrcat(opt_app_version, GetModuleVersion(buffer));
	
	GetModulePath(buffer, MAX_PATH);
	lstrcpy(opt_app_path, "-Djava.application.path=");
	lstrcat(opt_app_path, buffer);
	lstrcpy(opt_policy_path, "-Djava.security.policy=");
	lstrcat(opt_policy_path, buffer);
	
	GetModuleFileName(NULL, buffer, size);
	lstrcpy(opt_app_name, "-Djava.application.name=");
	lstrcat(opt_app_name, lstrrchr(buffer, '\\') + 1);
	
	lstrcat(opt_policy_path, "\\");
	*(lstrrchr(buffer, '.')) = 0;
	lstrcat(opt_policy_path, lstrrchr(buffer, '\\') + 1);
	lstrcat(opt_policy_path, ".policy");
	if(GetFileAttributes(opt_policy_path + 23) == 0xFFFFFFFF) {
		opt_policy_path[0] = 0x00;
	}
	
	GetModulePath(jre1, MAX_PATH);
	lstrcat(jre1, "\\jre");
	
	if(IsDirectory(jre1)) {
		SetEnvironmentVariable("JAVA_HOME", jre1);
		lstrcpy(binpath, jre1);
		lstrcat(binpath, "\\bin");
		lstrcpy(jvmpath, jre1);
		lstrcat(jvmpath, "\\bin\\client");
		lstrcpy(buffer, jre1);
		lstrcat(buffer, "\\lib\\ext");
	} else {
		GetModulePath(jre2, MAX_PATH);
		if(lstrrchr(jre2, '\\') != NULL && strlen(jre2) >= 4 && _stricmp(jre2 + strlen(jre2) - 4, "\\bin") == 0) {
			*(lstrrchr(jre2, '\\')) = 0;
			lstrcat(jre2, "\\jre");
			if(IsDirectory(jre2)) {
				SetEnvironmentVariable("JAVA_HOME", jre2);
				lstrcpy(binpath, jre2);
				lstrcat(binpath, "\\bin");
				lstrcpy(jvmpath, jre2);
				lstrcat(jvmpath, "\\bin\\client");
				lstrcpy(buffer, jre2);
				lstrcat(buffer, "\\lib\\ext");
			}
		}
	}
	
	if(jvmpath[0] == 0) {
		if(GetEnvironmentVariable("JAVA_HOME", jre3, MAX_PATH) > 0) {
			if(*(jre3 + strlen(jre3) - 1) != '\\') {
				lstrcat(jre3, "\\jre");
			} else {
				lstrcat(jre3, "jre");
			}
			if(IsDirectory(jre3)) {
				lstrcpy(binpath, jre3);
				lstrcat(binpath, "\\bin");
				lstrcpy(jvmpath, jre3);
				lstrcat(jvmpath, "\\bin\\client");
				lstrcpy(buffer, jre3);
				lstrcat(buffer, "\\lib\\ext");
			}
		}
	}
	
	if(jvmpath[0] == 0) {
		if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, subkey, 0, KEY_READ, &key) != ERROR_SUCCESS) {
			return;
		}
		if(RegQueryValueEx(key, "CurrentVersion", NULL, NULL, (LPBYTE)buffer, &size) != ERROR_SUCCESS) {
			return;
		}
		RegCloseKey(key);
		
		lstrcat(subkey, "\\");
		lstrcat(subkey, buffer);
		
		if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, subkey, 0, KEY_READ, &key) != ERROR_SUCCESS) {
			return;
		}
		
		size = MAX_PATH;
		if(RegQueryValueEx(key, "RuntimeLib", NULL, NULL, (LPBYTE)buffer, &size) != ERROR_SUCCESS) {
			return;
		}
		*(lstrrchr(buffer, '\\')) = 0;
		lstrcpy(jvmpath, buffer);
		lstrcpy(binpath, buffer);
		*(lstrrchr(binpath, '\\')) = 0;
		
		size = MAX_PATH;
		if(RegQueryValueEx(key, "JavaHome", NULL, NULL, (LPBYTE)buffer, &size) != ERROR_SUCCESS) {
			return;
		}
		SetEnvironmentVariable("JAVA_HOME", buffer);
		RegCloseKey(key);
	}
	
	lstrcpy(classpath, "-Djava.class.path=.");
	lstrcpy(extdirs, "-Djava.ext.dirs=");
	lstrcpy(libpath, "-Djava.library.path=.;");
	
	TCHAR lib1[MAX_PATH];
	TCHAR lib2[MAX_PATH];
	
	GetModulePath(lib1, MAX_PATH);
	lstrcat(lib1, "\\lib");
	
	if(IsDirectory(lib1)) {
		lstrcat(classpath, ";");
		lstrcat(classpath, lib1);
		lstrcat(extdirs, lib1);
		lstrcat(extdirs, ";");
		lstrcat(libpath, lib1);
		lstrcat(libpath, ";");
		AddPath(lib1);
	}
	
	GetModulePath(lib2, MAX_PATH);
	if(lstrrchr(lib2, '\\') != NULL && strlen(lib2) >= 4 && _stricmp(lib2 + strlen(lib2) - 4, "\\bin") == 0) {
		*(lstrrchr(lib2, '\\')) = 0;
		lstrcat(lib2, "\\lib");
		if(IsDirectory(lib2)) {
			lstrcat(classpath, ";");
			lstrcat(classpath, lib2);
			lstrcat(extdirs, lib2);
			lstrcat(extdirs, ";");
			lstrcat(libpath, lib2);
			lstrcat(libpath, ";");
			AddPath(lib2);
		}
	}
	
	lstrcat(extdirs, buffer);
	lstrcat(extdirs, "\\lib\\ext");
	
	if(GetEnvironmentVariable("PATH", buffer, 2048)) {
		lstrcat(libpath, buffer);
	}
}

void AddPath(LPCTSTR path) {
	char buf[2048];
	char old_path[2048];
	GetEnvironmentVariable("PATH", old_path, 2048);
	lstrcpy(buf, path);
	lstrcat(buf, ";");
	lstrcat(buf, old_path);
	SetEnvironmentVariable("PATH", buf);
}

LPTSTR GetModulePath(LPTSTR buffer, DWORD size) {
	GetModuleFileName(NULL, buffer, size);
	*(lstrrchr(buffer, '\\')) = 0;
	return buffer;
}

LPTSTR GetModuleVersion(LPTSTR buffer) {
	HRSRC hrsrc = FindResource(NULL, (LPCTSTR)VS_VERSION_INFO, RT_VERSION);
	VS_FIXEDFILEINFO* verInfo = (VS_FIXEDFILEINFO*)((char*)LockResource(LoadResource(NULL, hrsrc)) + 40);
	sprintf(buffer, "%d.%d.%d.%d",
		verInfo->dwFileVersionMS >> 16,
		verInfo->dwFileVersionMS & 0xFFFF,
		verInfo->dwFileVersionLS >> 16,
		verInfo->dwFileVersionLS & 0xFFFF
	);
	return buffer;
}

BOOL IsDirectory(LPTSTR path) {
	return (GetFileAttributes(path) != -1) && (GetFileAttributes(path) & FILE_ATTRIBUTE_DIRECTORY);
}

LPTSTR lstrrchr(LPTSTR source, TCHAR c) {
	LPTSTR tmp = source + lstrlen(source) - 1;
	while(tmp >= source) {
		if(*tmp == c) {
			return tmp;
		} else {
			tmp--;
		}
	}
	return NULL;
}
