import java.awt.Image;
import java.net.URL;
import java.util.HashMap;

import sun.awt.windows.WToolkit;

public class Toolkit extends WToolkit {
	HashMap images = new HashMap();
	
	public Image createImage(URL location) {
		String file = location.getFile();
		if(Loader.resources.containsKey(file)) {
			return super.createImage((byte[])Loader.resources.get(file));
		}
		return super.createImage(location);
	}
	
	public Image getImage(URL location) {
		String file = location.getFile();
		if(!images.containsKey(file)) {
			Image image;
			if(Loader.resources.containsKey(file)) {
				image = super.createImage((byte[])Loader.resources.get(file));
			} else {
				image = super.getImage(location);
			}
			images.put(file, image);
		}
		return (Image)images.get(file);
	}
}
