import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Loader extends ClassLoader {
    /* package private */ static HashMap resources = new HashMap();
    
	public Loader() {
		Thread.currentThread().setContextClassLoader(this);
	}
	
    private Class defineClass(byte[] resource) throws Throwable {
        String mainClassName = "";
        int pointer = -1;
        ArrayList classNames = new ArrayList();
        ArrayList classBuffers = new ArrayList();
        HashMap   depends = new HashMap();
        
        JarInputStream jar = new JarInputStream(new ByteArrayInputStream(resource));
        Manifest manifest = jar.getManifest();
        if(manifest != null) {
            mainClassName = manifest.getMainAttributes().getValue("Main-Class");
        }
        JarEntry entry;
        while((entry = jar.getNextJarEntry()) != null) {
            if(entry.getName().toLowerCase().endsWith(".class")) {
                String name = entry.getName().substring(0, entry.getName().length() - ".class".length()).replace('/', '.');
                byte[] data = getResourceData(jar);
                classNames.add(name);
                classBuffers.add(data);
            } else {
                if(entry.getName().charAt(0) == '/') {
                    resources.put(entry.getName(), getResourceData(jar));
                } else {
                    resources.put("/" + entry.getName(), getResourceData(jar));
                }
            }
        }
        while(classNames.size() > 0) {
            int n = classNames.size();
            for(int i = classNames.size() - 1; i >= 0; i--) {
                try {
                    defineClass((String)classNames.get(i), (byte[])classBuffers.get(i), 0, ((byte[])classBuffers.get(i)).length);
                    String pkgName = (String)classNames.get(i);
                    if(pkgName.lastIndexOf('.') >= 0) {
                        pkgName = pkgName.substring(0, pkgName.lastIndexOf('.'));
                        if(getPackage(pkgName) == null) {
                            definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                    }
                    classNames.remove(i);
                    classBuffers.remove(i);
                } catch(NoClassDefFoundError e) {
                	depends.put((String)classNames.get(i), e.getMessage().replaceAll("/", "."));
                } catch(UnsupportedClassVersionError e) {
					throw new UnsupportedClassVersionError(classNames.get(i) + ", "
						+ System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")"
					);
				}
            }
            if(n == classNames.size()) {
                for(int i = 0; i < classNames.size(); i++) {
                    System.err.println("NoClassDefFoundError: " + classNames.get(i));
                    String className = (String)classNames.get(i);
                    while(depends.containsKey(className)) {
                    	System.out.println("\t" + className + " depends on " + (String)depends.get(className));
                    	className = (String)depends.get(className);
                    }
                    System.out.println("");
                }
                break;
            }
        }
        try {
            return Class.forName(mainClassName, true, this);
        } catch(ClassNotFoundException e) {
            String className = mainClassName;
            while(depends.containsKey(className)) {
                className = (String)depends.get(className);
            }
            throw new ClassNotFoundException(className);
        }
    }
    
    public static int getRuntimeVersion() {
    	try {
    		return Integer.parseInt(dripNumber(System.getProperty("java.runtime.version")).substring(0, 3));
    	} catch(Exception e) {
    		return 0;
    	}
    }
    
    private static String dripNumber(String value) {
    	StringBuffer sb = new StringBuffer();
    	for(int i = 0; i < value.length(); i++) {
    		if('0' <= value.charAt(i) && value.charAt(i) <= '9') {
    			sb.append(value.charAt(i));
    		}
    	}
    	return sb.toString();
    }

    private static byte[] getResourceData(JarInputStream jar) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int size;
        while(jar.available() > 0) {
            size = jar.read(buffer);
            if(size > 0) {
                data.write(buffer, 0, size);
            }
        }
        return data.toByteArray();
    }
    
    public URL getResource(String name) {
		if(name.charAt(0) == '/') {
			name = name.substring(1);
		}
        if(resources.containsKey("/" + name)) {
            try {
                return new URL("file:///" + name);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return super.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
    	if(name.charAt(0) == '/') {
    		name = name.substring(1);
    	}
        if(resources.containsKey("/" + name)) {
            return new ByteArrayInputStream((byte[])resources.get("/" + name));
        }
        return super.getResourceAsStream(name);
    }
}
