#include <windows.h>
#include <process.h>
#include <shlobj.h>
#include <stdio.h>
#include <jni.h>

#include "jvm.h"
#include "dde_connect.h"

void CallMainMethod(void* arglist);
char** arg_split(char* buffer, int* p_argc);

void    InitResource(LPCTSTR name);
DWORD   GetResourceSize(LPCTSTR name);
jbyte*  GetResourceBuffer(LPCTSTR name);
jstring GetJString(const char* value);
LPSTR	GetModuleMutexName();

TCHAR  cache[] = "12345678901234567890123456789012";
jbyte* buffer = NULL;
DWORD  size   = 0;

jclass mainClass = NULL;
jmethodID mainMethod = NULL;

int main(int argc, char* argv[]) {
	LPTSTR ext_flags = NULL;
	if(GetResourceSize("EXTFLAGS") > 0) {
		ext_flags = _strupr((LPTSTR)GetResourceBuffer("EXTFLAGS"));
	}
	if(ext_flags != NULL && strstr(ext_flags, "DDE_CONNECT") != NULL) {
		if(dde_exec(CallMainMethod, GetModuleMutexName(), argc, argv) == DDE_CLIENT) {
			return 0;
		}
	}
	if(ext_flags != NULL && strstr(ext_flags, "SINGLE") != NULL) {
		if(CreateMutex(NULL, TRUE, GetModuleMutexName()), GetLastError() == ERROR_ALREADY_EXISTS) {
			return 0;
		}
	}
	
	LPTSTR vm_args_opt = NULL;
	if(GetResourceSize("VMARGS") > 0) {
		vm_args_opt = (LPTSTR)GetResourceBuffer("VMARGS");
	}
	if(CreateJavaVM(vm_args_opt) == NULL) {
		fputs("JavaVM 쐬ł܂łB\r\n", stderr);
		return -1;
	};
	// Toolkit
	jclass toolkitClass = env->DefineClass("Toolkit", NULL, GetResourceBuffer("TOOLKIT"), GetResourceSize("TOOLKIT"));
	if(toolkitClass == NULL) {
		fputs("Fialed to define class: Toolkit\r\n", stderr);
		return -5;
	}
	// Loader
	jclass loaderClass = env->DefineClass("Loader", NULL, GetResourceBuffer("LOADER"), GetResourceSize("LOADER"));
	if(loaderClass == NULL) {
		fputs("Fail to define class: Loader\r\n", stderr);
		return -2;
	}
	jmethodID loaderInit = env->GetMethodID(loaderClass, "<init>", "()V");
	if(loaderInit == NULL) {
		fputs("Fail to find method: Loader#init()\r\n", stderr);
		return -3;
	}
	jobject loader = env->NewObject(loaderClass, loaderInit);
	if(loader == NULL) {
		fputs("Fail to init: Loader\r\n", stderr);
		return -4;
	}
	jmethodID defineClass = env->GetMethodID(loaderClass, "defineClass", "([B)Ljava/lang/Class;");
	if(defineClass == NULL) {
		fputs("Fail to find method: Loader#defineClass(byte[])\n", stderr);
        return -6;
    }
	// Main-Class
	jbyteArray jar = env->NewByteArray(GetResourceSize("JAR"));
	env->SetByteArrayRegion(jar, 0, GetResourceSize("JAR"), GetResourceBuffer("JAR"));
	
	mainClass = (jclass)(env->CallObjectMethod(loader, defineClass, jar));
	if(mainClass == NULL) {
		env->ExceptionDescribe();
		return -7;
	}
	mainMethod = env->GetStaticMethodID(mainClass, "main", "([Ljava/lang/String;)V");
	if(mainMethod == NULL) {
		fputs("main Ă܂B\r\n", stderr);
		return -8;
	}
	
	jobjectArray args = env->NewObjectArray(argc - 1, env->FindClass("java/lang/String"), NULL);
	for(int i = 1; i < argc; i++) {
		env->SetObjectArrayElement(args, (i - 1), GetJString(argv[i]));
	}
	env->CallStaticVoidMethod(mainClass, mainMethod, args);
	
	env->ExceptionDescribe();
	env->ExceptionClear();
	DetachJavaVM();
	DestroyJavaVM();
}

void CallMainMethod(void* arglist) {
	int argc;
	char** argv = arg_split((char*)arglist, &argc);
	JNIEnv* env = AttachJavaVM();
	jobjectArray args = env->NewObjectArray(argc - 1, env->FindClass("java/lang/String"), NULL);
	for(int i = 1; i < argc; i++) {
		env->SetObjectArrayElement(args, (i - 1), GetJString(argv[i]));
	}
	env->CallStaticVoidMethod(mainClass, mainMethod, args);
	if(env->ExceptionCheck() == JNI_TRUE) {
		env->ExceptionDescribe();
		env->ExceptionClear();
	}
	DetachJavaVM();
	free(argv);
	free(arglist);
	_endthread();
}

char** arg_split(char* buffer, int* p_argc) {
	*p_argc = 0;
	int i;
	for(i = 0; i < strlen(buffer); i++) {
		*p_argc += (buffer[i] == '\n')?1:0;
	}
	char** argv = (char**)calloc(sizeof(char*), *p_argc);
	for(i = 0; i < *p_argc; i++) {
		argv[i] = strtok(i?NULL:buffer, "\n");
	}
	return argv;
}

jstring GetJString(const char* src) {
    if(src == NULL) {
        return NULL;
    }
	int wSize = MultiByteToWideChar(CP_ACP, 0, src, strlen(src), NULL, 0);
	WCHAR wBuf[wSize];
	MultiByteToWideChar(CP_ACP, 0, src,	strlen(src), wBuf, wSize);
	return env->NewString((jchar*)wBuf, wSize);
}

void InitResource(LPCTSTR name) {
	HRSRC hrsrc;
	
	if((hrsrc = FindResource(NULL, name, RT_RCDATA)) == NULL) {
		return;
	}
	size = SizeofResource(NULL, hrsrc);
	buffer = (jbyte*)LockResource(LoadResource(NULL, hrsrc));
	strcpy(cache, name);
}

DWORD GetResourceSize(LPCTSTR name) {
	if(strcmp(name, cache) != 0) {
		InitResource(name);
	}
	return size;
}

jbyte* GetResourceBuffer(LPCTSTR name) {
	if(strcmp(name, cache) != 0) {
		InitResource(name);
	}
	return buffer;
}

LPSTR GetModuleMutexName() {
	LPSTR mutexName = (LPSTR)malloc(MAX_PATH + 32);
	LPSTR moduleFileName = (LPSTR)malloc(MAX_PATH);
	
	GetModuleFileName(NULL, moduleFileName, MAX_PATH);
	strcat(strcpy(mutexName, "EXEWRAP:MUTEX:"), lstrrchr(moduleFileName, '\\') + 1);
	
	free(moduleFileName);
	return mutexName;
}
