#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "icon.h"

char** ParseOption(int argc, char* argv[]);
char*  GetResource(LPCTSTR name, LPCTSTR type, DWORD* size);
void   SetResource(LPCTSTR filename, LPCTSTR rscName, LPCTSTR rscType, char* rscData, DWORD rscSize);
void   CreateExeFile(LPCTSTR filename, char* data, DWORD size);
char*  GetFileData(LPCTSTR filename, DWORD* size);

DWORD  GetVersionBuild(LPTSTR filename);
char*  SetVersionInfo(LPCTSTR filename, char* versionNumber, DWORD previousBuild, char* fileDescription, char* copyright, char* jarfile);
void   SetApplicationIcon(LPCTSTR filename, LPCTSTR iconfile);

char defaultVersion[] = "0.0";

int main(int argc, char* argv[]) {
	char** opt = ParseOption(argc, argv);
	char* jarfile;
	char* exefile;
	char* exeBuffer;
	DWORD exeSize;
	char* jarBuffer;
	DWORD jarSize;
	DWORD previousBuild = 0;
	char* versionNumber;
	char* fileDescription;
	char* copyright;
	
	char* iconBuffer;
	DWORD iconSize;
	
	if((argc < 2) || ((opt['j'] == NULL) && (opt[0] == NULL))) {
		printf("exewrap 0.8.1 Native executable java application wrapper.\r\n"
			   "Copyright (C) 2005-2007 HIRUKAWA Ryo. All rights reserved.\r\n"
			   "\r\n"
			   "Usage: %s <options> <jar-file>\r\n"
			   "Options:\r\n"
			   "  -g              \t create GUI application.\r\n"
			   "  -s              \t create Service application.\r\n"
			   "  -e <ext-flags>  \t set extended flags.\r\n"
			   "  -a <vm-args>    \t set Java VM arguments.\r\n"
			   "  -i <icon-file>  \t set application icon.\r\n"
			   "  -v <version>    \t set version number.\r\n"
			   "  -d <description>\t set file description.\r\n"
			   "  -c <copyright>  \t set copyright.\r\n" 
			   "  -j <jar-file>   \t input jar-file.\r\n"
			   "  -o <exe-file>   \t output exe-file.\r\n"
			, argv[0]);
		exit(0);
	}
	
	if(opt['j'] && *opt['j'] != '-' && *opt['j'] != '\0') {
		jarfile = opt['j'];
	} else {
		jarfile = opt[0];
	}
	
	if(opt['o'] && *opt['o'] != '-' && *opt['o'] != '\0') {
		exefile = opt['o'];
	} else {
		exefile = (char*)GlobalAlloc(GMEM_FIXED, MAX_PATH);
		strcpy(exefile, jarfile);
		exefile[strlen(exefile) - 4] = 0;
		strcat(exefile, ".exe");
	}

	if(opt['g']) {
		exeBuffer = GetResource("IMAGE_GUI", RT_RCDATA, &exeSize);
	} else if(opt['s']) {
		exeBuffer = GetResource("IMAGE_SERVICE", RT_RCDATA, &exeSize);
	} else {		
		exeBuffer = GetResource("IMAGE_CONSOLE", RT_RCDATA, &exeSize);
	}
	
	previousBuild = GetVersionBuild(exefile);
	DeleteFile(exefile);
	
	jarBuffer = GetFileData(jarfile, &jarSize);
	CreateExeFile(exefile, exeBuffer, exeSize);
	SetResource(exefile, "JAR", RT_RCDATA, jarBuffer, jarSize);
	GlobalFree(jarBuffer);
	
	if(opt['e'] && *opt['e'] != '-' && *opt['e'] != '\0') {
		SetResource(exefile, "EXTFLAGS", RT_RCDATA, opt['e'], strlen(opt['e']) + 1);
	}
	
	if(opt['a'] && *opt['a'] != '\0') {
		SetResource(exefile, "VMARGS", RT_RCDATA, opt['a'], strlen(opt['a']) + 1);
	}
	
	if(opt['i'] && *opt['i'] != '-' && *opt['i'] != '\0') {
		SetApplicationIcon(exefile, opt['i']);
	}
	
	if(opt['v'] && *opt['v'] != '-' && *opt['v'] != '\0') {
		versionNumber = opt['v'];
	} else {
		versionNumber = defaultVersion;
	}
	if(opt['d'] && *opt['d'] != '-' && *opt['d'] != '\0') {
		fileDescription = opt['d'];
		if(opt['s']) {
			SetResource(exefile, "SVCDESC", RT_RCDATA, opt['d'], strlen(opt['d']) + 1);
		}
	} else {
		fileDescription = "";
	}
	if(opt['c'] && *opt['c'] != '-' && *opt['c'] != '\0') {
		copyright = opt['c'];
	} else {
		copyright = "";
	}
	char* newVersion = SetVersionInfo(exefile, versionNumber, previousBuild, fileDescription, copyright, jarfile);
	printf("%s  version %s\r\n", exefile, newVersion);
}

DWORD GetVersionBuild(LPTSTR filename) {
	/* GetFileVersionInfoSize, GetFileVersionInfo gƓ LoadLibrary gp炵
	 * ̌̃\[X݂܂ȂȂ悤łBȂ̂ŁA͂ EXEt@C
	 * rhio[o悤ɕύX܂B
	 */
	DWORD  build = 0;
	HANDLE hFile;
	char   HEADER[] = "VS_VERSION_INFO";
	char   buf[8192]; //1024ƑʖځBrhio[擾łȂB
	DWORD  size;
	int    i, j;
	
	if((hFile = CreateFile(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		return 0;
	}
	SetFilePointer(hFile, -1 * sizeof(buf), 0, FILE_END);
	ReadFile(hFile, buf, sizeof(buf), &size, NULL);
	CloseHandle(hFile);
	
	for(i = 0; i < size - strlen(HEADER); i++) {
		for(j = 0; j < strlen(HEADER); j++) {
			if(buf[i + j * 2] != HEADER[j]) break;
		}
		if(j == strlen(HEADER)) {
			build = ((buf[i + 47] << 8) & 0xFF00)
				  | ((buf[i + 46]     ) & 0x00FF);
		}
	}
	return build;
}

char* SetVersionInfo(LPCTSTR filename, char* versionNumber, DWORD previousBuild, char* fileDescription, char* copyright, char* jarfile) {
    int   i;
    int   ADDR_FILE_VERSION     = 0x00B8;
    int   ADDR_FILE_DESCRIPTION = 0x0164;
    int   ADDR_COPYRIGHT        = 0x020C;
    int   ADDR_INTERNAL_NAME    = 0x02B0;
    char* internalName;
    char  buffer[130];
	char* versioninfoBuffer;
	DWORD versioninfoSize;

	if(strrchr(jarfile, '\\') != NULL) {
		internalName = strrchr(jarfile, '\\') + 1;
	} else {
		internalName = jarfile;
	}

    strcpy(buffer, versionNumber);
    strcat(buffer, ".0.0.0.0");

	short major    = atoi(strtok(buffer, "."));
	short minor    = atoi(strtok(NULL, "."));
	short revision = atoi(strtok(NULL, "."));
	short build    = atoi(strtok(NULL, "."));
	
	// build IɎw肳ĂȂꍇAt@C擾l 1@Z build ƂB
	strcpy(buffer, versionNumber);
	if(strtok(buffer, ".") != NULL) {
		if(strtok(NULL, ".") != NULL) {
			if(strtok(NULL, ".") != NULL) {
				if(strtok(NULL, ".") != NULL) {
					previousBuild = build - 1;
				}
			}	
		}
	}

	build = previousBuild + 1;
	// build Z肱܂ŁB
	
	versioninfoBuffer = GetResource("VERSION_INFO", RT_RCDATA, &versioninfoSize);
	versioninfoBuffer[48] = minor & 0xFF;
	versioninfoBuffer[49] = (minor >> 8) & 0xFF;
	versioninfoBuffer[50] = major & 0xFF;
	versioninfoBuffer[51] = (major >> 8) & 0xFF;
	versioninfoBuffer[52] = build & 0xFF;
	versioninfoBuffer[53] = (build >> 8) & 0xFF;
	versioninfoBuffer[54] = revision & 0xFF;
	versioninfoBuffer[55] = (revision >> 8) & 0xFF;

    ZeroMemory(buffer, sizeof(char) * 130);
    MultiByteToWideChar(CP_ACP, 0, versionNumber, strlen(versionNumber), (WCHAR*)buffer, 128);
    for(i = 0; i < 128; i++) {
	    versioninfoBuffer[ADDR_FILE_VERSION + i] = buffer[i];
    }

    ZeroMemory(buffer, sizeof(char) * 130);
    MultiByteToWideChar(CP_ACP, 0, fileDescription, strlen(fileDescription), (WCHAR*)buffer, 128);
    for(i = 0; i < 128; i++) {
	    versioninfoBuffer[ADDR_FILE_DESCRIPTION + i] = buffer[i];
    }

	ZeroMemory(buffer, sizeof(char) * 130);
    MultiByteToWideChar(CP_ACP, 0, copyright, strlen(copyright), (WCHAR*)buffer, 128);
    for(i = 0; i < 128; i++) {
	    versioninfoBuffer[ADDR_COPYRIGHT + i] = buffer[i];
    }

	ZeroMemory(buffer, sizeof(char) * 130);
    MultiByteToWideChar(CP_ACP, 0, internalName, strlen(internalName), (WCHAR*)buffer, 128);
    for(i = 0; i < 128; i++) {
	    versioninfoBuffer[ADDR_INTERNAL_NAME + i] = buffer[i];
    }

	SetResource(filename, (LPCTSTR)VS_VERSION_INFO, RT_VERSION, versioninfoBuffer, versioninfoSize);
	
	char* newVersion = (char*)malloc(128);
	sprintf(newVersion, "%d.%d.%d.%d", major, minor, revision, build);
	return newVersion;
}

char** ParseOption(int argc, char* argv[]) {
	int i;
	char** opt = (char**)malloc(256 * 8);
	
	for(i = 0; i < 256; i++) {
		opt[i] = NULL;
	}
	if((argc > 1) && (*argv[1] != '-')) {
		opt[0] = argv[1];
	}
	while(*++argv) {
		if(*argv[0] == '-') {
			if(argv[1] == NULL) {
				opt[*(argv[0] + 1)] = "";
			} else {
				opt[*(argv[0] + 1)] = argv[1];
			}
		}
	}
	argv--;
	if((opt[0] == NULL) && (*argv[0] != '-')) {
		opt[0] = argv[0];
	}
	return opt;
}

char* GetResource(LPCTSTR name, LPCTSTR type, DWORD* size) {
	HRSRC hrsrc;
	
	if((hrsrc = FindResource(NULL, name, type)) == NULL) {
		fprintf(stderr, "Fail to FindResource: %s\n", name);
		exit(0);
	}
	*size = SizeofResource(NULL, hrsrc);
	return (char*)LockResource(LoadResource(NULL, hrsrc));
}	

void SetResource(LPCTSTR filename, LPCTSTR rscName, LPCTSTR rscType, char* rscData, DWORD rscSize) {
	HANDLE hRes = BeginUpdateResource(filename, FALSE);
	
	if(UpdateResource(hRes, rscType, rscName, MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), rscData, rscSize) == 0) {
		fprintf(stderr, "Failed to update resource: %s: %s\n", filename, rscName);
		exit(0);
	}
	EndUpdateResource(hRes, FALSE);
	CloseHandle(hRes);
}

void CreateExeFile(LPCTSTR filename, char* data, DWORD size) {
	HANDLE hFile;
	
	if((hFile = CreateFile(filename, GENERIC_WRITE, 0, NULL, TRUNCATE_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		if((hFile = CreateFile(filename, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
			fprintf(stderr, "Failed to create file: %s\n", filename);
			exit(0);
		}
	}
	
	DWORD writeSize;
	while(size > 0) {
		if(WriteFile(hFile, data, size, &writeSize, NULL) == 0) {
			fprintf(stderr, "Failed to write: %s\n", filename);
			exit(0);
		}
		data += writeSize;
		size -= writeSize;
	}
	CloseHandle(hFile);
}

char* GetFileData(LPCTSTR filename, DWORD* size) {
	HANDLE hFile;
	if((hFile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		fprintf(stderr, "Failed to read file: %s\n", filename);
		exit(0);
	}
	*size = GetFileSize(hFile, NULL);
	char* buf = (char*)GlobalAlloc(GMEM_FIXED, *size);

	char* p = buf;
	DWORD r = *size;
	DWORD readSize;

	while(r > 0) {
		if(ReadFile(hFile, p, r, &readSize, NULL) == 0) {
			fprintf(stderr, "Failed to read: %s\n", filename);
			free(buf);
			exit(0);
		}
		p += readSize;
		r -= readSize;
	}
	CloseHandle(hFile);

	return buf;
}

void SetApplicationIcon(LPCTSTR filename, LPCTSTR iconfile) {
	void *pvFile;
	DWORD nSize;
	int f, z;
	ICONDIR id, *pid;
	GRPICONDIR *pgid;
	HANDLE hResource = BeginUpdateResource(filename, FALSE);
	
	if(!strlen(iconfile)) {
		return;
	}
	if((f = _lopen(iconfile, OF_READ)) == -1) {
		return;
	}
	
	_lread(f, &id, sizeof(id));
	_llseek(f, 0, SEEK_SET);
	pid = (ICONDIR *) malloc(sizeof(ICONDIR) + sizeof(ICONDIRENTRY) * (id.idCount - 1));
	pgid = (GRPICONDIR *) malloc(sizeof(GRPICONDIR) + sizeof(GRPICONDIRENTRY) * (id.idCount - 1));
	_lread(f, pid, sizeof(ICONDIR) + sizeof(ICONDIRENTRY) * (id.idCount - 1));
	memcpy(pgid, pid, sizeof(GRPICONDIR));
	
	for(z = 0; z < id.idCount; z++) {
		pgid->idEntries[z].common = pid->idEntries[z].common;
		pgid->idEntries[z].nID = z + 1;
		nSize = pid->idEntries[z].common.dwBytesInRes;
		pvFile = malloc(nSize);
		if(!pvFile) {
			_lclose(f);
			return;
		}
		_llseek(f, pid->idEntries[z].dwImageOffset, SEEK_SET);
		_lread(f, pvFile, nSize);
		if(UpdateResource(hResource, RT_ICON, MAKEINTRESOURCE(z + 1), MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), pvFile, nSize) == 0) {
			fprintf(stderr, "Failed to set icon\n");
		}
		free(pvFile);
	}
	nSize = sizeof(GRPICONDIR) + sizeof(GRPICONDIRENTRY) * (id.idCount - 1);
	if(UpdateResource(hResource, RT_GROUP_ICON, MAKEINTRESOURCE(1), MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), pgid, nSize) == 0) {
		fprintf(stderr, "Failed to set icon group\n");
	}
	_lclose(f);
	EndUpdateResource(hResource, FALSE);
	CloseHandle(hResource);
	return;
}
