#include <windows.h>
#include <process.h>
#include <winuser.h>

#include "dde_connect.h"

typedef WINUSERAPI BOOL (WINAPI* USER32_AllowSetForegroundWindow)(DWORD);

int dde_exec(void(*start_address)(void*), char* mutexName, int argc, char* argv[]);

static void server(void* arglist);
static void client(char* serviceName, int argc, char* argv[]);
static char* arg_fusion(int argc, char* argv[]);
static char* convert_buffer(HDDEDATA hdata);

HDDEDATA CALLBACK DdeCallbackServer(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwData1, DWORD dwData2);
HDDEDATA CALLBACK DdeCallbackClient(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwData1, DWORD dwData2);

static HSZ hTopicName;
static DWORD processId = 0;
static HDDEDATA hProcessId = NULL;

void (*p_callback_function)(void*);

int dde_exec(void(*_p_callback_function)(void*), char* mutexName, int argc, char* argv[]) {
	p_callback_function = _p_callback_function;
	
	if(CreateMutex(NULL, TRUE, mutexName), GetLastError() != ERROR_ALREADY_EXISTS) {
		_beginthread(server, 0, mutexName);
	} else {
		client(mutexName, argc, argv);
		return DDE_CLIENT;
	}
}

static void server(void* serviceName) {
	DWORD inst = 0;
	DWORD flags = APPCLASS_STANDARD | CBF_FAIL_ADVISES | CBF_FAIL_EXECUTES | CBF_FAIL_SELFCONNECTIONS | CBF_SKIP_ALLNOTIFICATIONS;
	DdeInitialize(&inst, DdeCallbackServer, flags, 0);
	HSZ hServiceName = DdeCreateStringHandle(inst, (CHAR*)serviceName, CP_WINANSI);
	hTopicName = DdeCreateStringHandle(inst, "COMMAND_LINE", CP_WINANSI);
	processId = GetCurrentProcessId();
	hProcessId = DdeCreateDataHandle(inst, (LPBYTE)&processId, sizeof(DWORD), 0, hTopicName, CF_TEXT, HDATA_APPOWNED );
	DdeNameService(inst, hServiceName, 0, DNS_REGISTER);
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	DdeUninitialize(inst);
	_endthread();
}

static void client(char* serviceName, int argc, char* argv[]) {
	DWORD inst = 0;
	DdeInitialize(&inst, DdeCallbackClient, APPCMD_CLIENTONLY, 0);
	HSZ hServiceName = DdeCreateStringHandle(inst, serviceName, CP_WINANSI);
	hTopicName = DdeCreateStringHandle(inst, "COMMAND_LINE", CP_WINANSI);
	char* data = arg_fusion(argc, argv);
	HCONV hconv = DdeConnect(inst, hServiceName, hTopicName, NULL);
	HDDEDATA hdata = DdeClientTransaction((LPBYTE)NULL, 0, hconv, hTopicName, CF_TEXT, XTYP_REQUEST, 500, NULL);
	if(sizeof(DWORD) == DdeGetData(hdata, NULL, 0, 0)) {
		DdeGetData(hdata, (LPBYTE)&processId, sizeof(DWORD), 0);
		USER32_AllowSetForegroundWindow pAllowSetForegroundWindow;
		HMODULE user32 = LoadLibrary("user32.dll");
		if(user32 != NULL) {
			pAllowSetForegroundWindow = (USER32_AllowSetForegroundWindow)GetProcAddress(user32, "AllowSetForegroundWindow");
			if(pAllowSetForegroundWindow != NULL) {
				pAllowSetForegroundWindow(processId);
			}
			FreeLibrary(user32);
		}
	}
	DdeClientTransaction((LPBYTE)data, strlen(data) + 1, hconv, hTopicName, CF_TEXT, XTYP_POKE, 500, NULL);
	DdeDisconnect(hconv);
	DdeUninitialize(inst);
}

static char* arg_fusion(int argc, char* argv[]) {
	int size = 1;
	int i;
	for(i = 0; i < argc; i++) {
		size += strlen(argv[i]) + 1;
	}
	char* buffer = (char*)calloc(size, 1);
	for(i = 0; i < argc; i++) {
		strcat(buffer, argv[i]);
		strcat(buffer, "\n");
	}
	return buffer;
}

static char* convert_buffer(HDDEDATA hdata) {
	DWORD size = DdeGetData(hdata, NULL, 0, 0);
	char* buffer = (char*)malloc(size);
	DdeGetData(hdata, (BYTE*)buffer, size, 0L);
	return buffer;
}

HDDEDATA CALLBACK DdeCallbackServer(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwData1, DWORD dwData2) {
	switch(uType) {
	case XTYP_CONNECT:
		return (HDDEDATA)((hsz1 == hTopicName)?TRUE:FALSE);
	case XTYP_REQUEST:
		if(hsz1 == hTopicName && hsz2 == hTopicName) {
			return hProcessId;
		}
		return (HDDEDATA)NULL;
	case XTYP_POKE:
		if(hsz1 == hTopicName && hsz2 == hTopicName) {
			_beginthread(p_callback_function, 0, convert_buffer(hdata));
		}
		return (HDDEDATA)DDE_FACK;
	}
	return (HDDEDATA)NULL;
}

HDDEDATA CALLBACK DdeCallbackClient(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwData1, DWORD dwData2) {
	return (HDDEDATA)NULL;
}
