#include <windows.h>
#include <stdio.h>

int main(int argc, char* argv[]) {

	if(argc < 4) {
		printf("Usage: %s <filename> <resource-name> <resource-file>\n", argv[0]);
		return -1;
	}

	char* filepath = argv[1];
	char* rscName  = argv[2];
	char* rscFileName = argv[3];
	
	HANDLE hRscFile;
	if((hRscFile = CreateFile(rscFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		printf("Failed to open: %s", rscFileName);
		return -2;		
	}
	DWORD  rscSize = GetFileSize(hRscFile, NULL);
	
	char* rscData = (char*)malloc(rscSize);

	char* p = rscData;
	DWORD r = rscSize;
	DWORD readSize;

	while(r > 0) {
		if(ReadFile(hRscFile, p, r, &readSize, NULL) == 0) {
			printf("Failed to read: %s", rscFileName);
			return -3;
		}
		p += readSize;
		r -= readSize;
	}
	CloseHandle(hRscFile);
	
	HANDLE hRes = BeginUpdateResource(filepath, FALSE);
	
	if(UpdateResource(hRes, RT_RCDATA, rscName, MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), rscData, rscSize) == 0) {
		printf("Failed to update resource.");
	}

	EndUpdateResource(hRes, FALSE);
	return 0;
}
