/*
 * Decompiled with CFR 0.152.
 */
package examples.applet;

import examples.applet.AppletDto;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class T2Applet
extends JApplet {
    private JTextField nameTextField;
    private JLabel eedaLabel;

    @Override
    public void init() {
        try {
            this.setSize(400, 400);
            ImageIcon eeda = new ImageIcon(T2Applet.class.getResource("eeda_orange.png"));
            this.eedaLabel = new JLabel(eeda);
            this.getContentPane().add((Component)this.eedaLabel, "Center");
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.nameTextField = new JTextField();
            this.nameTextField.setPreferredSize(new Dimension(200, 20));
            JButton button = new JButton("\u9001\u4fe1");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    T2Applet.this.sendButtonClick();
                }
            });
            panel.add(new JLabel("\u304a\u540d\u524d\uff1a"));
            panel.add(this.nameTextField);
            panel.add(button);
            this.getContentPane().add((Component)panel, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendButtonClick() {
        try {
            String server = this.getParameter("server");
            System.out.println(server);
            if (server == null) {
                server = "http://localhost:30000/t2-samples/applet";
            }
            URL pageUrl = new URL(server);
            URLConnection con = pageUrl.openConnection();
            con.setUseCaches(false);
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
            w.write("name=" + URLEncoder.encode(this.nameTextField.getText(), "UTF-8"));
            w.flush();
            InputStream in = con.getInputStream();
            ObjectInputStream objIn = new ObjectInputStream(in);
            AppletDto resultDto = (AppletDto)objIn.readObject();
            out.close();
            in.close();
            this.getContentPane().remove(this.eedaLabel);
            ImageIcon newEeda = resultDto.getImageIcon();
            System.out.println(String.valueOf(newEeda.getIconHeight()) + ":" + newEeda.getIconWidth());
            this.eedaLabel = new JLabel(newEeda);
            this.getContentPane().add((Component)this.eedaLabel, "Center");
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

