/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.inject;

import java.lang.reflect.Array;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.ExpressionAware;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.AutoboxingUtil;
import org.t2framework.commons.util.ConverterUtil;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.annotation.core.Inject;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.el.ExpressionUtil;
import org.t2framework.lucy.inject.Injector;
import org.t2framework.lucy.inject.InjectorUtil;

public abstract class AbstractInjector<C extends ConfigContainer>
implements Injector {
    protected C container;
    protected InjectInfo injectInfo;
    protected boolean injectByAnnotation;
    protected boolean injectByConfiguration;

    public AbstractInjector(C container) {
        this.container = (ConfigContainer)Assertion.notNull(container);
        this.setup(container);
    }

    protected void setup(C container) {
        this.injectByAnnotation = InjectorUtil.hasInjectAnnotation(container);
        this.injectByConfiguration = InjectorUtil.hasInjectConfiguration(container);
        this.setInjectInfo(new InjectInfo((ConfigContainer)container));
    }

    protected C getConfigContainer() {
        return this.container;
    }

    protected InjectInfo getInjectInfo() {
        return this.injectInfo;
    }

    protected void setInjectInfo(InjectInfo injectInfo) {
        this.injectInfo = injectInfo;
    }

    protected Object[] convertTypes(Object obj, Class<?> componentType) {
        int length = Array.getLength(obj);
        Object[] values = (Object[])Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Object convert = ConverterUtil.convert((Object)Array.get(obj, i), componentType);
            Array.set(values, i, convert);
        }
        return values;
    }

    protected Object[] evaluateExpression(ExpressionAware expressionAware, Lucy lucy) {
        return ExpressionUtil.evaluateExpression(expressionAware, lucy);
    }

    protected Object[] prepareArgsByTypes(Class<?>[] types, final Lucy lucy, InjectInfo info) {
        Assertion.notNull(types, (String)"types");
        Assertion.notNull((Object)lucy, (String)"lucy");
        Object[] args = null;
        int typesLength = types.length;
        Object[] values = new Object[typesLength];
        for (int i = 0; i < typesLength; ++i) {
            Class<?> type = types[i];
            Object value = InjectorUtil.getInjectableComponent(type, info, i, new InjectorUtil.InjectHandler<Object>(){

                @Override
                public Object getFromIdentifier(Object identifier) {
                    return lucy.get(identifier);
                }

                @Override
                public Object getFromType(Class type) {
                    return !type.isArray() ? lucy.get(type) : lucy.getAll(type.getComponentType());
                }
            });
            values[i] = AutoboxingUtil.getDefaultValueIfNull(types[i], (Object)value);
        }
        if (values != null && 0 < values.length) {
            args = values;
        }
        return args;
    }

    protected static class InjectInfo {
        protected String[] names;
        protected Class<?>[] paramTypes;

        public InjectInfo(ConfigContainer container) {
            Config config = container.findConfig(InjectConfig.class);
            if (config == null) {
                config = container.findConfig(Inject.class);
            }
            this.setup(config);
        }

        public String[] getNames() {
            return this.names;
        }

        public Class<?>[] getParameterTypes() {
            return this.paramTypes;
        }

        public boolean hasNames() {
            if (this.names == null) {
                return false;
            }
            return this.names.length != 1 || !"".equals(this.names[0]);
        }

        public boolean hasParameterTypes() {
            int length = this.paramTypes.length;
            if (this.paramTypes == null || length == 0) {
                return false;
            }
            return 1 < length || length == 1 && this.paramTypes[0] != Object.class;
        }

        private void setup(Config config) {
            if (config instanceof InjectConfig) {
                InjectConfig injectConfig = (InjectConfig)config;
                this.paramTypes = injectConfig.getParameterTypes();
            } else {
                if (!InjectorUtil.isInjectAnnotation(config)) {
                    throw new IllegalStateException();
                }
                Inject inject = (Inject)config.getAnnotation();
                this.names = inject.name();
                this.paramTypes = inject.types();
            }
        }
    }
}

