/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.t2framework.commons.annotation.core.Component;
import org.t2framework.commons.exception.NoSuchComponentException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.NameDesc;
import org.t2framework.commons.meta.PackageDesc;
import org.t2framework.commons.meta.PackageDescHolder;
import org.t2framework.commons.meta.impl.NameDescImpl;
import org.t2framework.commons.meta.impl.PackageDescHolderImpl;
import org.t2framework.commons.meta.impl.SimpleBeanDescImpl;
import org.t2framework.commons.util.AnnotationUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.Reflections;
import org.t2framework.lucy.BeanDescBag;
import org.t2framework.lucy.BeanDescStrategy;
import org.t2framework.lucy.ComponentLoader;
import org.t2framework.lucy.ConfigBindResult;
import org.t2framework.lucy.ConfigBinder;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.LucyComponentRegistrar;
import org.t2framework.lucy.LucyContext;
import org.t2framework.lucy.LucyUtil;
import org.t2framework.lucy.exception.CyclicReferenceRuntimeException;
import org.t2framework.lucy.exception.LucyComponentRegistrarNotFoundRuntimeException;
import org.t2framework.lucy.exception.NoComponentAnnotationException;
import org.t2framework.lucy.impl.DefaultLucyConfiguration;
import org.t2framework.lucy.impl.LucyContextImpl;
import org.t2framework.lucy.spi.ComponentBuilder;
import org.t2framework.lucy.spi.LucyConfiguration;

public class LucyImpl
implements Lucy {
    protected Lifecycle phase;
    protected List<PackageDesc> packageDescList = CollectionsUtil.newArrayList();
    protected ConfigBinder binder;
    protected LucyConfiguration lucyConf;
    protected BeanDescStrategy beanDescStrategy;
    private ThreadLocal<BuildingPath> buildingPaths = new ThreadLocal();
    protected static Logger log = Logger.getLogger(LucyImpl.class);
    protected PackageDescHolder delegate = new PackageDescHolderImpl();
    protected LucyContext context;

    public LucyImpl() {
        this(new DefaultLucyConfiguration());
    }

    public LucyImpl(LucyConfiguration conf) {
        Assertion.notNull((Object)conf);
        this.lucyConf = conf;
        this.setLifecycle(Lifecycle.CONTAINER_CREATED);
    }

    @Override
    public void init() {
        this.binder = this.lucyConf.loadConfigBinder();
        this.beanDescStrategy = this.lucyConf.getBeanDescStrategy(this);
        this.context = new LucyContextImpl(this.beanDescStrategy);
        this.registerLucy();
        this.setLifecycle(Lifecycle.CONTAINER_CONFIGURED);
    }

    protected void registerLucy() {
        SimpleBeanDescImpl lucyDesc = new SimpleBeanDescImpl((Object)this, Lucy.class);
        this.registerBeanDescByClasses((BeanDesc)lucyDesc, Arrays.asList(Lucy.class, PackageDescHolder.class, ComponentLoader.class));
    }

    @Override
    public <T> BeanDesc<T> getBeanDesc(Object identifier) {
        Assertion.notNull((Object)identifier);
        if (identifier instanceof Class) {
            return this.getBeanDesc((Class)identifier);
        }
        BeanDesc<T> beanDesc = this.getBeanDescByIdentifier(identifier);
        this.buildComponent(identifier, beanDesc);
        return beanDesc;
    }

    @Override
    public <T> T get(Object identifier) {
        if (identifier instanceof Class) {
            return this.get((Class)identifier);
        }
        BeanDesc<T> beanDesc = this.getBeanDescByIdentifier(identifier);
        return this.buildComponent(identifier, beanDesc);
    }

    protected <T> BeanDesc<T> getBeanDescByIdentifier(Object identifier) {
        return this.context.getBeanDescByIdentifier(identifier);
    }

    @Override
    public <T> BeanDesc<T> getBeanDesc(Class<? super T> key) {
        BeanDesc<? super T> beanDesc = this.getBeanDesc0(key);
        this.buildComponent(key, beanDesc);
        return beanDesc;
    }

    @Override
    public <T> T get(Class<? super T> key) {
        BeanDesc<? super T> beanDesc = this.getBeanDesc0(key);
        return this.buildComponent(key, beanDesc);
    }

    protected <T> BeanDesc<T> getBeanDesc0(Class<? super T> key) {
        BeanDescBag<T> beanDescBag = this.context.getBeanDescBag(key);
        if (beanDescBag != null) {
            return beanDescBag.getBeanDesc();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T buildComponent(Object key, BeanDesc<T> beanDesc) {
        if (beanDesc == null) {
            return this.beanDescStrategy.handleNoBeanDesc(key);
        }
        BuildingPath buildingPath = this.getBuildingPath();
        if (buildingPath.contains(beanDesc)) {
            if (beanDesc.isSingleton()) {
                return (T)beanDesc.getComponent();
            }
            if (!buildingPath.isSingletonPresent()) {
                throw new CyclicReferenceRuntimeException(key, beanDesc);
            }
        }
        buildingPath.add(beanDesc);
        try {
            ConfigBindResult result;
            Object t = beanDesc.getComponent();
            if (t != null) {
                if (LucyUtil.isSimpleType(t.getClass()) || beanDesc.isSingleton()) {
                    Object object = t;
                    return (T)object;
                }
                this.bind(beanDesc);
            }
            if ((result = this.context.getConfigBindResult(beanDesc)) == null) {
                throw new NoSuchComponentException(key);
            }
            Object object = this.createComponentBuilder(beanDesc).build(t, result);
            return (T)object;
        }
        finally {
            buildingPath.remove(beanDesc);
            if (buildingPath.isEmpty()) {
                this.removeBuildingPath();
            }
        }
    }

    BuildingPath getBuildingPath() {
        BuildingPath buildingPath = this.buildingPaths.get();
        if (buildingPath == null) {
            buildingPath = new BuildingPath();
            this.buildingPaths.set(buildingPath);
        }
        return buildingPath;
    }

    void removeBuildingPath() {
        this.buildingPaths.set(null);
    }

    protected <T> ComponentBuilder createComponentBuilder(BeanDesc<T> beanDesc) {
        return this.lucyConf.createBuilder(beanDesc, this);
    }

    @Override
    public <T> Lucy register(Class<? extends T> componentClass) {
        Assertion.notNull(componentClass, (String)"componentClass");
        LucyImpl.assertComponentAnnotation(componentClass);
        if (BeanDescFactory.hasCache(componentClass)) {
            return this;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        this.register(beanDesc);
        return this;
    }

    @Override
    public <T> Lucy register(Class<? extends T> componentClass, Object identifier) {
        Assertion.notNull(componentClass, (String)"componentClass");
        Assertion.notNull((Object)identifier, (String)"identifier");
        LucyImpl.assertComponentAnnotation(componentClass);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        this.register((T)beanDesc, identifier);
        return this;
    }

    @Override
    public <T> Lucy register(BeanDesc<? extends T> beanDesc, Object identifier) {
        Assertion.notNull(beanDesc, (String)"beanDesc");
        Assertion.notNull((Object)identifier, (String)"identifier");
        NameDesc<T> nameDesc = this.createNameDesc(identifier);
        this.registerWithNameDesc(beanDesc, nameDesc);
        return this;
    }

    protected <T> Lucy registerWithNameDesc(BeanDesc<? extends T> beanDesc, NameDesc<T> nameDesc) {
        Assertion.notNull(beanDesc, (String)"beanDesc");
        Assertion.notNull(nameDesc, (String)"nameDesc");
        beanDesc.setNameDesc(nameDesc);
        this.register(beanDesc);
        return this;
    }

    @Override
    public <T> Lucy register(T t) {
        Assertion.notNull(t, (String)"instance");
        Class<?> componentClass = t.getClass();
        LucyImpl.assertComponentAnnotation(componentClass);
        if (BeanDescFactory.hasCache(t)) {
            return this;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(t);
        this.register(beanDesc);
        return this;
    }

    @Override
    public <T> Lucy register(T t, Object identifier) {
        Assertion.notNull(t, (String)"instance");
        Assertion.notNull((Object)identifier, (String)"identifier");
        LucyImpl.assertComponentAnnotation(t.getClass());
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(t);
        return this.register((T)beanDesc, identifier);
    }

    @Override
    public <T> Lucy register(BeanDesc<? extends T> beanDesc) {
        Assertion.notNull(beanDesc, (String)"beanDesc");
        List dependencyClassesList = beanDesc.getClassDesc().getDependencyClassesList();
        this.registerBeanDescByClasses(beanDesc, dependencyClassesList);
        this.bind(beanDesc);
        return this;
    }

    protected <T> void bind(BeanDesc<? extends T> beanDesc) {
        if (this.context.hasConfigBindResult(beanDesc)) {
            return;
        }
        ConfigBindResult bindResult = this.binder.bind(beanDesc);
        if (!bindResult.isInitialized()) {
            bindResult.initializeBehaviors();
        }
        this.context.putConfigBindResult(beanDesc, bindResult);
    }

    protected <T> void registerBeanDescByClasses(BeanDesc<? extends T> beanDesc, List<Class<?>> dependencyClassesList) {
        if (beanDesc.hasName()) {
            this.context.addNamedBeanDesc(beanDesc);
        }
        for (Class<?> c : dependencyClassesList) {
            this.context.putBeanDesc(c, beanDesc);
        }
    }

    @Override
    public synchronized void destroy() {
        this.setLifecycle(Lifecycle.CONTAINER_DESTROY);
        for (ConfigBindResult result : this.context) {
            result.destroyBehaviors();
        }
        this.context.destroy();
    }

    protected static <T> void assertComponentAnnotation(Class<? extends T> componentClass) {
        if (Reflections.PackageUtil.isJavaPackage(componentClass)) {
            return;
        }
        if (!AnnotationUtil.hasAnnotationType(Component.class, (Annotation[])componentClass.getAnnotations())) {
            throw new NoComponentAnnotationException(componentClass);
        }
    }

    @Override
    public <T> BeanDesc<T>[] getBeanDescs(Class<? super T> key) {
        return (BeanDesc[])this.getBeanDescList(key).toArray((Object[])Array.newInstance(key, 0));
    }

    @Override
    public <T> T[] getAll(Class<? super T> key) {
        List<BeanDesc<T>> beanDescList = this.getBeanDescList(key);
        Object[] components = (Object[])Array.newInstance(key, beanDescList.size());
        int idx = 0;
        for (BeanDesc<? super T> beanDesc : beanDescList) {
            components[idx++] = this.buildComponent(key, beanDesc);
        }
        return components;
    }

    protected <T> List<BeanDesc<T>> getBeanDescList(Class<? super T> key) {
        return this.context.getBeanDescList(key);
    }

    protected <T> NameDesc<T> createNameDesc(Object identifier) {
        if (NameDesc.class.isInstance(identifier)) {
            return (NameDesc)NameDesc.class.cast(identifier);
        }
        return new NameDescImpl(identifier);
    }

    @Override
    public void load(Object componentDefinition) {
        Assertion.notNull((Object)componentDefinition);
        LucyComponentRegistrar<Object> registrar = this.lucyConf.getAcceptableComponentRegistrar(componentDefinition);
        if (registrar == null) {
            throw new LucyComponentRegistrarNotFoundRuntimeException(componentDefinition);
        }
        registrar.register(this, componentDefinition);
    }

    @Override
    public <T> boolean hasComponent(Class<T> key) {
        List<BeanDesc<T>> beanDescList = this.getBeanDescList(key);
        return !beanDescList.isEmpty();
    }

    @Override
    public boolean hasComponent(Object identifier) {
        return this.getBeanDesc(Assertion.notNull((Object)identifier)) != null;
    }

    @Override
    public synchronized <T> T injectDependency(T t) {
        this.register(t);
        Class<?> clazz = t.getClass();
        return (T)this.get(clazz);
    }

    public void addPackageDesc(PackageDesc packageDesc) {
        this.delegate.addPackageDesc(packageDesc);
    }

    public PackageDesc getPackageDesc(String regex) {
        return this.delegate.getPackageDesc(regex);
    }

    public Iterator<PackageDesc> iterator() {
        return this.delegate.iterator();
    }

    public Iterator<Class<?>> iteratorClasses(String regex) {
        return this.delegate.iteratorClasses(regex);
    }

    public Iterator<PackageDesc> iteratorPackageDescs(String regex) {
        return this.delegate.iteratorPackageDescs(regex);
    }

    @Override
    public Lifecycle getLifecycle() {
        return this.phase;
    }

    public void setLifecycle(Lifecycle phase) {
        this.phase = phase;
    }

    @Override
    public <T> void pretend(Class<? extends T> original, Class<? extends T> newone) {
        if (this.phase == Lifecycle.CONTAINER_CONFIGURED) {
            this.pretend0(original, BeanDescFactory.getBeanDesc(newone));
        }
    }

    @Override
    public <T> void pretend(Class<? extends T> original, T instance) {
        if (this.phase == Lifecycle.CONTAINER_CONFIGURED) {
            this.pretend0(original, BeanDescFactory.getBeanDesc(instance));
        }
    }

    @Override
    public <T> void pretend(Object identifier, Class<? extends T> newone) {
        if (this.phase == Lifecycle.CONTAINER_CONFIGURED) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(newone);
            this.pretend0(identifier, beanDesc);
        }
    }

    @Override
    public <T> void pretend(Object identifier, T instance) {
        if (this.phase == Lifecycle.CONTAINER_CONFIGURED) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(instance);
            this.pretend0(identifier, beanDesc);
        }
    }

    protected <T> void pretend0(Class<? extends T> original, BeanDesc<T> beanDesc) {
        BeanDescBag<T> bag = this.context.getBeanDescBag(original);
        if (bag == null) {
            return;
        }
        List<BeanDesc<T>> list = bag.getBeanDescList();
        if (!list.isEmpty()) {
            BeanDesc<? extends T> oldBeanDesc = list.get(0);
            if (oldBeanDesc.hasName()) {
                this.context.getNamedBeanDescList().remove(oldBeanDesc);
            }
            this.context.removeBeanDesc(oldBeanDesc);
            this.context.removeConfigBindResult(oldBeanDesc);
            this.register(beanDesc);
        }
    }

    protected <T> void pretend0(Object identifier, BeanDesc<? extends T> beanDesc) {
        BeanDesc oldBeanDesc = this.context.getBeanDescByIdentifier(identifier);
        if (oldBeanDesc != null) {
            if (oldBeanDesc.hasName()) {
                this.context.getNamedBeanDescList().remove(oldBeanDesc);
            }
            this.context.removeBeanDesc(oldBeanDesc);
            this.context.removeConfigBindResult(oldBeanDesc);
            this.register((T)beanDesc, identifier);
        }
    }

    protected static class BuildingPath {
        List<BeanDesc<?>> beanDescList = new ArrayList();

        protected BuildingPath() {
        }

        public void add(BeanDesc<?> beanDesc) {
            this.beanDescList.add(beanDesc);
        }

        public boolean isEmpty() {
            return this.beanDescList.isEmpty();
        }

        public void remove(BeanDesc<?> beanDesc) {
            this.beanDescList.remove(this.beanDescList.size() - 1);
        }

        public boolean isSingletonPresent() {
            for (BeanDesc<?> bd : this.beanDescList) {
                if (!bd.isSingleton()) continue;
                return true;
            }
            return false;
        }

        public boolean contains(BeanDesc<?> beanDesc) {
            for (BeanDesc<?> bd : this.beanDescList) {
                if (bd != beanDesc) continue;
                return true;
            }
            return false;
        }
    }
}

