/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.NameDesc;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.lucy.BeanDescBag;
import org.t2framework.lucy.BeanDescStrategy;
import org.t2framework.lucy.ConfigBindResult;
import org.t2framework.lucy.LucyContext;

public class LucyContextImpl
implements LucyContext {
    protected Map<Class<?>, BeanDescBag<?>> beanDescBagMap = CollectionsUtil.newConcurrentHashMap();
    protected List<BeanDesc<?>> namedBeanDescList = CollectionsUtil.newArrayList();
    protected Map<BeanDesc<?>, ConfigBindResult> bindMap = CollectionsUtil.newConcurrentHashMap();
    protected BeanDescStrategy beanDescStrategy;

    public LucyContextImpl(BeanDescStrategy beanDescStrategy) {
        this.beanDescStrategy = beanDescStrategy;
    }

    @Override
    public <T> BeanDescBag<T> getBeanDescBag(Class<? extends T> key) {
        return this.beanDescBagMap.get(key);
    }

    @Override
    public <T> void putBeanDesc(Class<?> clazz, BeanDesc<? extends T> beanDesc) {
        BeanDescBag<?> bag = this.beanDescBagMap.get(clazz);
        if (bag == null) {
            bag = new BeanDescBag(clazz, this.beanDescStrategy);
            this.beanDescBagMap.put(clazz, bag);
        }
        bag.add(beanDesc);
    }

    @Override
    public void destroy() {
        BeanDescFactory.clear(this.beanDescBagMap.keySet());
        this.beanDescBagMap.clear();
        this.namedBeanDescList.clear();
        this.bindMap.clear();
    }

    @Override
    public <T> List<BeanDesc<T>> getBeanDescList(Class<? super T> key) {
        BeanDescBag<?> beanDescBag = this.beanDescBagMap.get(key);
        if (beanDescBag != null) {
            return beanDescBag.getBeanDescList();
        }
        return Collections.emptyList();
    }

    @Override
    public <T> BeanDesc<T> getBeanDescByIdentifier(Object identifier) {
        BeanDesc<?> beanDesc = null;
        if (!this.namedBeanDescList.isEmpty()) {
            for (BeanDesc<?> bd : this.namedBeanDescList) {
                NameDesc nameDesc = bd.getNameDesc();
                if (!nameDesc.isIdentified(identifier)) continue;
                beanDesc = bd;
                break;
            }
        }
        return beanDesc;
    }

    @Override
    public <T> void addNamedBeanDesc(BeanDesc<T> beanDesc) {
        if (!this.namedBeanDescList.contains(beanDesc)) {
            this.namedBeanDescList.add(beanDesc);
        }
    }

    @Override
    public <T> ConfigBindResult getConfigBindResult(BeanDesc<? extends T> beanDesc) {
        return this.bindMap.get(beanDesc);
    }

    @Override
    public <T> boolean hasConfigBindResult(BeanDesc<? extends T> beanDesc) {
        return this.bindMap.containsKey(beanDesc);
    }

    @Override
    public <T> void putConfigBindResult(BeanDesc<? extends T> beanDesc, ConfigBindResult bindResult) {
        this.bindMap.put(beanDesc, bindResult);
    }

    @Override
    public Iterator<ConfigBindResult> iterator() {
        return this.bindMap.values().iterator();
    }

    @Override
    public List<BeanDesc<?>> getNamedBeanDescList() {
        return this.namedBeanDescList;
    }

    @Override
    public <T> ConfigBindResult removeConfigBindResult(BeanDesc<? extends T> beanDesc) {
        if (this.bindMap.containsKey(beanDesc)) {
            return this.bindMap.remove(beanDesc);
        }
        return null;
    }

    @Override
    public <T> void removeBeanDesc(BeanDesc<? extends T> beanDesc) {
        for (Class c : beanDesc.getClassDesc().getDependencyClassesList()) {
            this.beanDescBagMap.remove(c);
        }
    }
}

