/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.MessageFormatter;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.config.stax.Attributes;
import org.t2framework.lucy.config.stax.XmlEventContext;
import org.t2framework.lucy.config.stax.XmlEventHandler;

public class PropertiesTagHandler
implements XmlEventHandler {
    public static final String NAME_ATTRIBUTE = "name";

    @Override
    public void start(XmlEventContext context, Attributes attributes) {
        String name = attributes.getAndRemoveValue(NAME_ATTRIBUTE);
        if (StringUtil.isEmpty((String)name)) {
            String message = MessageFormatter.getMessage((String)"ELucyCore0014", (Object[])new Object[]{"properties", context.getLineNumber(), context.getColumnNumber(), NAME_ATTRIBUTE});
            throw new IllegalStateException(message);
        }
        context.push(name);
    }

    @Override
    public void end(XmlEventContext context, String body) {
        String name = (String)context.pop();
        if (StringUtil.isEmpty((String)body)) {
            String message = MessageFormatter.getMessage((String)"ELucyCore0015", (Object[])new Object[]{"properties", context.getLineNumber(), context.getColumnNumber()});
            throw new IllegalStateException(message);
        }
        InputStream is = ResourceUtil.getResourceAsStream((String)body);
        Properties prop = new Properties();
        try {
            prop.load(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        context.getLucy().register(prop, (Object)name);
    }
}

