/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.meta;

import java.util.Map;
import org.t2framework.commons.exception.NoSuchInstaceConfigRuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.lucy.config.meta.InstanceConfig;
import org.t2framework.lucy.config.meta.impl.PrototypeInstanceConfig;
import org.t2framework.lucy.config.meta.impl.SingletonInstanceConfig;

public class InstanceConfigFactory {
    public static final String SINGLETON = "singleton";
    public static final String PROTOTYPE = "prototype";
    public static final String DEFAULT = "singleton";
    protected static final Map<String, InstanceConfig> map = CollectionsUtil.newHashMap();

    public static InstanceConfig getInstanceConfig(String type) {
        Assertion.notNull((Object)type);
        InstanceConfig instanceConfig = map.get(type);
        if (instanceConfig == null) {
            throw new NoSuchInstaceConfigRuntimeException(type);
        }
        return instanceConfig;
    }

    public static void addInstanceConfig(InstanceConfig instanceConfig) {
        Assertion.notNull((Object)instanceConfig);
        map.put(instanceConfig.getName(), instanceConfig);
    }

    static {
        map.put("singleton", new SingletonInstanceConfig());
        map.put(PROTOTYPE, new PrototypeInstanceConfig());
    }
}

