/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.meta;

import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.config.meta.ConfigurableBeanDesc;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.config.meta.impl.ConstructorInjectConfig;
import org.t2framework.lucy.config.meta.impl.PropertyInjectConfig;

public enum AutoInject {
    PROPERTY{

        @Override
        public String getName() {
            return "property";
        }

        @Override
        public <T> void setupAutoInject(ConfigurableBeanDesc<T> beanDesc) {
            for (PropertyDesc pd : beanDesc.getAllPropertyDesc()) {
                if (pd.hasConfig(InjectConfig.class)) continue;
                Class<?>[] paramTypes = pd.getWriteMethod().getParameterTypes();
                pd.addConfig((Config)new PropertyInjectConfig(paramTypes, true));
            }
        }
    }
    ,
    CONSTRUCTOR{

        @Override
        public String getName() {
            return "constructor";
        }

        @Override
        public <T> void setupAutoInject(ConfigurableBeanDesc<T> beanDesc) {
            ConstructorDesc cd = beanDesc.getConstructorDesc();
            if (!cd.hasConfig(InjectConfig.class)) {
                ConstructorInjectConfig injectConfig = new ConstructorInjectConfig(true);
                cd.addConfig((Config)injectConfig);
                beanDesc.setConstructorDesc(cd);
            }
        }
    }
    ,
    ALL{

        @Override
        public String getName() {
            return "all";
        }

        @Override
        public <T> void setupAutoInject(ConfigurableBeanDesc<T> beanDesc) {
            CONSTRUCTOR.setupAutoInject(beanDesc);
            PROPERTY.setupAutoInject(beanDesc);
        }
    }
    ,
    NONE{

        @Override
        public String getName() {
            return "";
        }

        @Override
        public <T> void setupAutoInject(ConfigurableBeanDesc<T> beanDesc) {
        }
    };


    public abstract String getName();

    public abstract <T> void setupAutoInject(ConfigurableBeanDesc<T> var1);

    public static AutoInject get(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return NONE;
        }
        if ((name = name.toLowerCase().trim()).equals(CONSTRUCTOR.getName())) {
            return CONSTRUCTOR;
        }
        if (name.equals(PROPERTY.getName())) {
            return PROPERTY;
        }
        if (name.equals(ALL.getName())) {
            return ALL;
        }
        return NONE;
    }

    public String toString() {
        return this.getName();
    }
}

