/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.behavior;

import java.util.Properties;
import org.t2framework.commons.annotation.ConfigurationTarget;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.annotation.core.PropertiesInject;
import org.t2framework.lucy.spi.AbstractBehavior;

@ConfigurationTarget(value={PropertiesInject.class})
public class PropertiesInjectBehavior
extends AbstractBehavior {
    public PropertiesInjectBehavior(BeanDesc beanDesc, MethodDesc md, Config cd) {
        super(beanDesc, md, cd);
    }

    public PropertiesInjectBehavior(BeanDesc beanDesc, PropertyDesc pd, Config cd) {
        super(beanDesc, pd, cd);
    }

    @Override
    public <T> T execute(T t, Lucy lucy) {
        Assertion.notNull((Object)lucy);
        String value = null;
        PropertiesInject propertiesInject = (PropertiesInject)this.getConfig().getAnnotation();
        String propertiesFileName = propertiesInject.name();
        String key = propertiesInject.key();
        value = this.findValue(propertiesFileName, key, lucy);
        if (value != null) {
            this.invoke(t, new Object[]{value});
        }
        return t;
    }

    protected <T> void invoke(T t, Object[] args) {
        MethodDesc methodDesc = this.getMethodDesc();
        if (methodDesc == null) {
            methodDesc = this.getPropertyDesc().getWriteMethodDesc();
        }
        methodDesc.invoke(t, args);
    }

    protected String findValue(String propertiesFileName, String key, Lucy lucy) {
        Properties[] all;
        if (lucy.hasComponent(propertiesFileName)) {
            Properties prop = (Properties)lucy.get(propertiesFileName);
            return prop.getProperty(key);
        }
        for (Properties p : all = lucy.getAll(Properties.class)) {
            if (!p.containsKey(key)) continue;
            return p.getProperty(key);
        }
        return null;
    }

    @Override
    public Lifecycle getLifecycle() {
        return Lifecycle.COMPONENT_CREATED;
    }
}

