/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.behavior;

import org.t2framework.commons.annotation.ConfigurationTarget;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Logger;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.annotation.core.Inject;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.inject.Injector;
import org.t2framework.lucy.inject.MethodInjector;
import org.t2framework.lucy.inject.PropertyInjector;
import org.t2framework.lucy.spi.AbstractBehavior;

@ConfigurationTarget(value={Inject.class, InjectConfig.class})
public class InjectBehavior
extends AbstractBehavior {
    protected static Logger logger = Logger.getLogger(InjectBehavior.class);
    protected final Injector injector;

    public InjectBehavior(BeanDesc beanDesc, MethodDesc md, Config cd) {
        super(beanDesc, md, cd);
        this.injector = new MethodInjector(md);
    }

    public InjectBehavior(BeanDesc beanDesc, PropertyDesc pd, Config cd) {
        super(beanDesc, pd, cd);
        this.injector = new PropertyInjector(pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(T t, Lucy lucy) {
        Assertion.notNull((Object)lucy);
        InjectBehavior injectBehavior = this;
        synchronized (injectBehavior) {
            this.injector.inject(t, lucy);
        }
        return t;
    }

    @Override
    public Lifecycle getLifecycle() {
        return Lifecycle.COMPONENT_CREATED;
    }
}

